/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu;

import com.mrbysco.forcecraft.capabilities.pack.PackItemStackHandler;
import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.ItemCardItem;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.util.FindingUtil;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;

public class ForcePackMenu
extends AbstractContainerMenu {
    private ItemStack heldStack;
    private int upgrades;
    private PackItemStackHandler inventory;

    public boolean m_6875_(Player playerIn) {
        return !playerIn.m_5833_();
    }

    public static ForcePackMenu fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        PackItemStackHandler handler = new PackItemStackHandler();
        handler.setUpgrades(data.readInt());
        return new ForcePackMenu(windowId, playerInventory, handler);
    }

    public ForcePackMenu(int id, Inventory playerInventory, PackItemStackHandler inv) {
        super((MenuType)ForceMenus.FORCE_PACK.get(), id);
        this.heldStack = FindingUtil.findInstanceStack(playerInventory.f_35978_, stack -> stack.m_41720_() instanceof ForcePackItem);
        if (this.heldStack == null || this.heldStack.m_41619_()) {
            playerInventory.f_35978_.m_6915_();
            return;
        }
        this.inventory = inv;
        this.upgrades = 0;
        this.upgrades = this.inventory.getUpgrades();
        int numRows = this.upgrades + 1;
        int xPosC = 17;
        int yPosC = 20;
        for (int j = 0; j < numRows; ++j) {
            for (int k = 0; k < 8; ++k) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, k + j * 8, xPosC + k * 18, yPosC + j * 18){

                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        return !(stack.m_41720_() instanceof ForcePackItem) && !(stack.m_41720_() instanceof ForceBeltItem);
                    }
                });
            }
        }
        int xPos = 8;
        int yPos = 36 + numRows * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInventory, x, xPos + x * 18, yPos + 58));
        }
    }

    public void m_6877_(Player player) {
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                CompoundTag tag = stack.m_41783_();
                if (!(stack.m_41720_() instanceof ItemCardItem) || tag == null || !tag.m_128441_("RecipeContents")) continue;
                CompoundTag recipeContents = tag.m_128469_("RecipeContents");
                NonNullList ingredientList = NonNullList.m_122779_();
                ArrayList<ItemStack> mergeList = new ArrayList<ItemStack>();
                for (int j = 0; j < 9; ++j) {
                    ItemStack recipeStack = ItemStack.m_41712_((CompoundTag)recipeContents.m_128469_("slot_" + j));
                    if (recipeStack.m_41619_()) continue;
                    if (ingredientList.isEmpty()) {
                        ingredientList.add((Object)recipeStack);
                        continue;
                    }
                    mergeList.add(recipeStack);
                }
                for (ItemStack recipeStack : mergeList) {
                    if (ingredientList.isEmpty()) continue;
                    ArrayList<ItemStack> buffer = new ArrayList<ItemStack>();
                    for (ItemStack ingredient : ingredientList) {
                        if (ingredient != null && !ingredient.m_41619_() && ItemStack.m_150942_((ItemStack)ingredient, (ItemStack)recipeStack)) {
                            int maxCount;
                            int addedCount = ingredient.m_41613_() + recipeStack.m_41613_();
                            if (addedCount <= (maxCount = ingredient.m_41741_())) {
                                recipeStack.m_41764_(0);
                                ingredient.m_41764_(addedCount);
                            } else if (recipeStack.m_41613_() < maxCount) {
                                recipeStack.m_41774_(maxCount - ingredient.m_41613_());
                                ingredient.m_41764_(maxCount);
                            }
                        }
                        if (recipeStack.m_41619_()) continue;
                        buffer.add(recipeStack);
                    }
                    if (buffer.isEmpty()) continue;
                    ingredientList.addAll(buffer);
                }
                mergeList.clear();
                ArrayList<ItemStack> restList = new ArrayList<ItemStack>();
                for (int k = 0; k < this.inventory.getSlots(); ++k) {
                    ItemStack restStack;
                    if (k == i || (restStack = this.inventory.getStackInSlot(k)).m_41619_()) continue;
                    restList.add(restStack);
                }
                boolean canCraft = true;
                int craftCount = 64;
                for (ItemStack ingredient : ingredientList) {
                    int countPossible = 0;
                    for (ItemStack rest : restList) {
                        if (ingredient.m_41720_() != rest.m_41720_() || !ItemStack.m_41658_((ItemStack)ingredient, (ItemStack)rest)) continue;
                        countPossible = (int)((double)countPossible + (double)rest.m_41613_() / (double)ingredient.m_41613_());
                    }
                    if (countPossible == 0) {
                        canCraft = false;
                        craftCount = 0;
                        break;
                    }
                    if (countPossible >= craftCount) continue;
                    craftCount = countPossible;
                }
                ItemStack craftStack = ItemStack.m_41712_((CompoundTag)recipeContents.m_128469_("result"));
                if (!canCraft || craftCount <= 0) continue;
                for (int l = 0; l < craftCount; ++l) {
                    for (ItemStack ingredient : ingredientList) {
                        for (ItemStack rest : restList) {
                            if (ingredient.m_41720_() != rest.m_41720_() || !ItemStack.m_41658_((ItemStack)ingredient, (ItemStack)rest) || rest.m_41613_() < ingredient.m_41613_()) continue;
                            rest.m_41774_(ingredient.m_41613_());
                        }
                    }
                    ItemStack stackCopy = craftStack.m_41777_();
                    ItemStack craftedStack = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)stackCopy, (boolean)false);
                    if (craftedStack.m_41619_()) continue;
                    player.m_36176_(craftedStack, true);
                }
            }
            CompoundTag tag = this.heldStack.m_41784_();
            tag.m_128405_("SlotsUsed", ItemHandlerUtils.getUsedSlots((IItemHandler)this.inventory));
            this.heldStack.m_41751_(tag);
        }
        super.m_6877_(player);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && this.m_38853_(slotId).m_7993_().m_41720_() instanceof ForcePackItem) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public int getUpgrades() {
        return this.upgrades;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (itemstack.m_41720_() instanceof ForcePackItem) {
                return ItemStack.f_41583_;
            }
            int containerSlots = this.f_38839_.size() - player.m_150109_().f_35974_.size();
            if (index < containerSlots ? !this.m_38903_(itemstack1, containerSlots, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, containerSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }
}

