/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.infuser;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.recipe.InfuseRecipe;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class UpgradeBookData {
    private UpgradeBookTier tier = UpgradeBookTier.ZERO;
    private final Map<Integer, Set<ResourceLocation>> recipesUsed = new HashMap<Integer, Set<ResourceLocation>>();
    private int points = 0;
    private String progressCache = "";

    public UpgradeBookData(ItemStack book) {
        if (book.m_41720_() != ForceRegistry.UPGRADE_TOME.get()) {
            ForceCraft.LOGGER.error("invalid book data entering book {}", (Object)book);
            return;
        }
        CompoundTag tag = book.m_41783_();
        if (tag != null && tag.m_128441_("tier")) {
            this.read(book, tag);
        } else {
            this.updateCache();
            this.write(book);
        }
    }

    public int nextTier() {
        if (this.getTier() == UpgradeBookTier.FINAL) {
            return 0;
        }
        return Math.max(0, this.getTier().pointsForLevelup() - this.points);
    }

    public void onRecipeApply(InfuseRecipe recipe, ItemStack bookStack) {
        Integer tier = recipe.getTier().ordinal();
        Set<ResourceLocation> tierSet = new HashSet<ResourceLocation>();
        if (this.recipesUsed.containsKey(tier)) {
            tierSet = this.recipesUsed.get(tier);
        }
        tierSet.add(recipe.m_6423_());
        this.recipesUsed.put(tier, tierSet);
        this.tryLevelUp();
        this.write(bookStack);
    }

    public void incrementPoints(int incoming) {
        this.points += incoming;
        this.tryLevelUp();
    }

    private void tryLevelUp() {
        if (this.canLevelUp()) {
            this.points -= this.getTier().pointsForLevelup();
            this.setTier(this.getTier().incrementTier());
            this.updateCache();
        }
    }

    private void updateCache() {
        int recipesThisTier;
        Set<ResourceLocation> thisTier = this.recipesUsed.get(this.tier.ordinal());
        int n = recipesThisTier = thisTier == null ? 0 : thisTier.size();
        if (!InfuseRecipe.RECIPESBYLEVEL.isEmpty()) {
            int totalThisTier = InfuseRecipe.RECIPESBYLEVEL.get(this.tier.ordinal()).size();
            this.progressCache = recipesThisTier + "/" + totalThisTier;
        }
    }

    private boolean canLevelUp() {
        Set<ResourceLocation> thisTier = this.recipesUsed.get(this.tier.ordinal());
        int recipesThisTier = thisTier == null ? 0 : thisTier.size();
        int totalThisTier = InfuseRecipe.RECIPESBYLEVEL.get(this.tier.ordinal()).size();
        this.updateCache();
        if (this.points < this.getTier().pointsForLevelup() || this.getTier() == UpgradeBookTier.FINAL) {
            return false;
        }
        return recipesThisTier >= totalThisTier;
    }

    private void read(ItemStack book, CompoundTag tag) {
        this.progressCache = tag.m_128461_("progressCache");
        this.setTier(UpgradeBookTier.values()[tag.m_128451_("tier")]);
        this.points = tag.m_128451_("points");
        for (UpgradeBookTier tier : UpgradeBookTier.values()) {
            HashSet<ResourceLocation> tierSet = new HashSet<ResourceLocation>();
            ListTag listTag = (ListTag)tag.m_128423_("tier" + tier.ordinal());
            if (listTag != null) {
                for (Tag value : listTag) {
                    CompoundTag tg = (CompoundTag)value;
                    String id = tg.m_128461_("id");
                    if (id.isEmpty() || "minecraft:".equalsIgnoreCase(id)) continue;
                    tierSet.add(ResourceLocation.m_135820_((String)id));
                }
            }
            this.recipesUsed.put(tier.ordinal(), tierSet);
        }
    }

    public CompoundTag write(ItemStack bookInSlot) {
        CompoundTag tag = bookInSlot.m_41784_();
        tag.m_128359_("progressCache", this.progressCache);
        tag.m_128405_("tier", this.getTier().ordinal());
        tag.m_128405_("points", this.points);
        for (UpgradeBookTier tier : UpgradeBookTier.values()) {
            Set<ResourceLocation> tierSet = this.recipesUsed.get(tier.ordinal());
            if (tierSet == null) {
                tierSet = new HashSet<ResourceLocation>();
            }
            ListTag listTag = new ListTag();
            for (ResourceLocation id : tierSet) {
                if ("minecraft:".equalsIgnoreCase(id.toString())) continue;
                CompoundTag tg = new CompoundTag();
                tg.m_128359_("id", id.toString());
                listTag.add((Object)tg);
            }
            tag.m_128365_("tier" + tier.ordinal(), (Tag)listTag);
        }
        return tag;
    }

    public String getProgressCache() {
        return this.progressCache;
    }

    public UpgradeBookTier getTier() {
        return this.tier;
    }

    public void setTier(UpgradeBookTier tier) {
        this.tier = tier;
    }

    public int getPoints() {
        return this.points;
    }
}

