/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceTags;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BaconatorItem
extends BaseItem {
    public static final String HAS_FOOD_TAG = "forcecraft:hasItems";

    public BaconatorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack firstStack;
        ItemStack itemstack = playerIn.m_21120_(handIn);
        IItemHandler handler = (IItemHandler)itemstack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (playerIn.m_6144_()) {
            boolean isFull = ItemHandlerUtils.isFull(handler);
            if (!isFull) {
                boolean extracted = ItemHandlerUtils.extractStackFromPlayer(playerIn.m_150109_(), handler, stack -> !stack.m_41619_() && stack.m_41614_() && stack.m_204117_(ForceTags.BACONATOR_FOOD));
                boolean hasItems = ItemHandlerUtils.hasItems(handler);
                if (!extracted) {
                    if (hasItems) {
                        itemstack.m_41721_(itemstack.m_41773_() == 1 ? 0 : 1);
                    }
                } else {
                    level.m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                CompoundTag tag = itemstack.m_41784_();
                tag.m_128379_(HAS_FOOD_TAG, hasItems);
            }
        } else if (ItemHandlerUtils.hasItems(handler) && !(firstStack = ItemHandlerUtils.getFirstItem(handler)).m_41619_() && playerIn.m_36391_(firstStack.m_41720_().m_41473_().m_38747_())) {
            playerIn.m_6672_(handIn);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        ItemStack firstStack = ItemHandlerUtils.getFirstItem(handler);
        if (firstStack != null && !firstStack.m_41619_()) {
            entityLiving.m_5584_(level, firstStack);
            level.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_12233_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return stack;
    }

    public UseAnim m_6164_(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        ItemStack firstStack = ItemHandlerUtils.getFirstItem(handler);
        return firstStack != null && firstStack.m_41720_().m_41472_() ? UseAnim.EAT : UseAnim.NONE;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.m_41773_() == 1 && entityIn instanceof Player) {
            IItemHandler handler;
            ItemStack firstStack;
            Player playerIn = (Player)entityIn;
            if (level.m_46467_() % 20L == 0L && !playerIn.m_150110_().f_35937_ && playerIn.m_36391_(false) && stack.m_41784_().m_128471_(HAS_FOOD_TAG) && !(firstStack = ItemHandlerUtils.getFirstItem(handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null))).m_41619_()) {
                playerIn.m_5584_(level, firstStack);
                level.m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12233_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        ItemStack firstStack = ItemHandlerUtils.getFirstItem(handler);
        if (!firstStack.m_41619_() && firstStack.m_41720_().m_41472_()) {
            return firstStack.m_41720_().m_41473_().m_38748_() ? 16 : 32;
        }
        return 0;
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41773_() == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"forcecraft.baconator.shift.carrying").m_130940_(ChatFormatting.DARK_RED));
            IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
            if (handler != null) {
                int stacks = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack foodStack = handler.getStackInSlot(i);
                    if (foodStack.m_41619_()) continue;
                    tooltip.add((Component)Component.m_237113_((String)(foodStack.m_41613_() + "x ")).m_7220_(foodStack.m_41786_()).m_130940_(ChatFormatting.GOLD));
                    ++stacks;
                }
                if (stacks == 0) {
                    tooltip.add((Component)Component.m_237115_((String)"forcecraft.baconator.shift.nothing").m_130940_(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"forcecraft.baconator.shift.text").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InventoryProvider();
    }

    private static class InventoryProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ItemStackHandler((Integer)ConfigHandler.COMMON.baconatorMaxStacks.get()){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41614_() && stack.m_204117_(ForceTags.BACONATOR_FOOD);
            }
        });

        private InventoryProvider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return this.inventory.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            if (this.inventory.isPresent()) {
                return ((ItemStackHandler)this.inventory.resolve().get()).serializeNBT();
            }
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.inventory.ifPresent(h -> h.deserializeNBT(nbt));
        }
    }
}

