/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities.goal;

import com.mrbysco.forcecraft.entities.IColdMob;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraftforge.event.ForgeEventFactory;

public class EatGrassToRestoreGoal
extends Goal {
    private static final Predicate<BlockState> IS_GRASS = BlockStatePredicate.m_61287_((Block)Blocks.f_50034_);
    private final Mob grassEaterEntity;
    private final Level entityWorld;
    private int eatingGrassTimer;

    public EatGrassToRestoreGoal(Mob grassEaterEntityIn) {
        this.grassEaterEntity = grassEaterEntityIn;
        this.entityWorld = grassEaterEntityIn.f_19853_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.grassEaterEntity.m_217043_().m_188503_(this.grassEaterEntity.m_6162_() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos blockpos = this.grassEaterEntity.m_20183_();
        if (IS_GRASS.test(this.entityWorld.m_8055_(blockpos))) {
            return true;
        }
        return this.entityWorld.m_8055_(blockpos.m_7495_()).m_60713_(Blocks.f_50440_);
    }

    public void m_8056_() {
        this.eatingGrassTimer = 40;
        this.entityWorld.m_7605_((Entity)this.grassEaterEntity, (byte)10);
        this.grassEaterEntity.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.eatingGrassTimer = 0;
    }

    public boolean m_8045_() {
        return this.eatingGrassTimer > 0;
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    public void m_8037_() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.getEatingGrassTimer() == 4) {
            BlockPos blockpos = this.grassEaterEntity.m_20183_();
            if (IS_GRASS.test(this.entityWorld.m_8055_(blockpos))) {
                if (ForgeEventFactory.getMobGriefingEvent((Level)this.entityWorld, (Entity)this.grassEaterEntity)) {
                    this.entityWorld.m_46961_(blockpos, false);
                }
                this.transformMob();
            } else {
                BlockPos blockpos1 = blockpos.m_7495_();
                if (this.entityWorld.m_8055_(blockpos1).m_60713_(Blocks.f_50440_)) {
                    if (ForgeEventFactory.getMobGriefingEvent((Level)this.entityWorld, (Entity)this.grassEaterEntity)) {
                        this.entityWorld.m_46796_(2001, blockpos1, Block.m_49956_((BlockState)Blocks.f_50440_.m_49966_()));
                        this.entityWorld.m_7731_(blockpos1, Blocks.f_50493_.m_49966_(), 2);
                    }
                    this.transformMob();
                }
            }
        }
    }

    public void transformMob() {
        Mob mob = this.grassEaterEntity;
        if (mob instanceof IColdMob) {
            IColdMob coldMob = (IColdMob)mob;
            coldMob.transformMob((LivingEntity)this.grassEaterEntity, this.entityWorld);
        }
    }
}

