/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capabilities.pack;

import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.registry.ForceTags;
import com.mrbysco.forcecraft.storage.StorageManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class PackItemStackHandler
extends ItemStackHandler {
    private static final int SLOTS_PER_UPGRADE = 8;
    private static final int MAX_UPGRADES = 4;
    public static final String NBT_UPGRADES = "Upgrades";
    private int upgrades;

    public PackItemStackHandler() {
        super(40);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return !(stack.m_41720_() instanceof ForcePackItem) && !stack.m_204117_(ForceTags.HOLDS_ITEMS) && super.isItemValid(slot, stack);
    }

    public int getSlotsInUse() {
        return (this.upgrades + 1) * 8;
    }

    public int getUpgrades() {
        return this.upgrades;
    }

    public void setUpgrades(int upgrades) {
        this.upgrades = upgrades;
    }

    public void applyUpgrade() {
        ++this.upgrades;
        this.forceUpdate();
    }

    public void applyUpgrade(int upgrades) {
        this.upgrades += upgrades;
        this.forceUpdate();
    }

    public void applydowngrade() {
        --this.upgrades;
        this.forceUpdate();
    }

    public void applydowngrade(int upgrades) {
        this.upgrades -= upgrades;
        this.forceUpdate();
    }

    public void forceUpdate() {
        if (this.upgrades > 4) {
            this.upgrades = 4;
        }
        if (this.upgrades < 0) {
            this.upgrades = 0;
        }
        this.onContentsChanged(0);
    }

    protected void onContentsChanged(int slot) {
        StorageManager.getPacks().m_77762_();
    }

    public boolean canUpgrade(UpgradeBookData bd) {
        if (this.upgrades >= 4) {
            return false;
        }
        if (bd.getTier().asInt() >= UpgradeBookTier.TWO.asInt() && this.upgrades == 0) {
            return true;
        }
        if (bd.getTier().asInt() >= UpgradeBookTier.THREE.asInt() && this.upgrades == 1) {
            return true;
        }
        if (bd.getTier().asInt() >= UpgradeBookTier.FOUR.asInt() && this.upgrades == 2) {
            return true;
        }
        return bd.getTier().asInt() >= UpgradeBookTier.FIVE.asInt() && this.upgrades == 3;
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_(NBT_UPGRADES, this.upgrades);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setUpgrades(nbt.m_128425_(NBT_UPGRADES, 3) ? nbt.m_128451_(NBT_UPGRADES) : this.upgrades);
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        this.onLoad();
    }
}

