/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blockentities;

import com.google.common.collect.Lists;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.UpgradeCoreItem;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractForceFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    public static final int INPUT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    public static final int UPGRADE_SLOT = 0;
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    public final ItemStackHandler handler = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 1) {
                ItemStack itemstack = this.getStackInSlot(1);
                return AbstractForceFurnaceBlockEntity.isFuel(stack) || stack.m_41720_() == Items.f_42446_ && itemstack.m_41720_() != Items.f_42446_;
            }
            return slot != 2;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            super.setStackInSlot(slot, stack);
            if (slot == 0) {
                AbstractForceFurnaceBlockEntity.this.m_6596_();
            }
        }
    };
    private LazyOptional<IItemHandler> handlerHolder = LazyOptional.of(() -> this.handler);
    public final ItemStackHandler upgradeHandler = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.getStackInSlot(slot).m_41619_() && stack.m_41720_() instanceof UpgradeCoreItem && stack.m_41613_() == 1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    };
    private LazyOptional<IItemHandler> upgradeHandlerHolder = LazyOptional.of(() -> this.upgradeHandler);
    private static final List<ResourceLocation> hopperBlacklist = List.of(new ResourceLocation("hopper"), new ResourceLocation("cyclic", "hopper"), new ResourceLocation("cyclic", "hopper_gold"), new ResourceLocation("cyclic", "hopper_fluid"), new ResourceLocation("uppers", "upper"), new ResourceLocation("goldenhopper", "golden_hopper"), new ResourceLocation("woodenhopper", "wooden_hopper"));
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private int burnSpeed;
    private int cookingSpeed;
    protected final ContainerData furnaceData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> AbstractForceFurnaceBlockEntity.this.litTime;
                case 1 -> AbstractForceFurnaceBlockEntity.this.litDuration;
                case 2 -> AbstractForceFurnaceBlockEntity.this.cookingProgress;
                case 3 -> AbstractForceFurnaceBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractForceFurnaceBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    AbstractForceFurnaceBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    AbstractForceFurnaceBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    AbstractForceFurnaceBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    protected AbstractCookingRecipe currentRecipe;
    protected ItemStack failedMatch = ItemStack.f_41583_;
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractForceFurnaceBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected RecipeType<? extends AbstractCookingRecipe> getRecipeType() {
        ItemStack upgrade = this.getUpgrade();
        if (!upgrade.m_41619_()) {
            if (upgrade.m_41720_() == ForceRegistry.FREEZING_CORE.get()) {
                return (RecipeType)ForceRecipes.FREEZING.get();
            }
            if (upgrade.m_41720_() == ForceRegistry.GRINDING_CORE.get()) {
                return (RecipeType)ForceRecipes.GRINDING.get();
            }
        }
        return RecipeType.f_44108_;
    }

    public void setUpgrade(ItemStack upgrade) {
        this.upgradeHandler.setStackInSlot(0, upgrade);
    }

    public ItemStack getUpgrade() {
        return this.upgradeHandler.getStackInSlot(0);
    }

    public boolean isEfficient() {
        ItemStack upgrade = this.getUpgrade();
        return !this.getUpgrade().m_41619_() && upgrade.m_41720_() == ForceRegistry.HEAT_CORE.get();
    }

    public boolean isFast() {
        ItemStack upgrade = this.getUpgrade();
        return !this.getUpgrade().m_41619_() && upgrade.m_41720_() == ForceRegistry.SPEED_CORE.get();
    }

    public boolean hasXPMultiplied() {
        ItemStack upgrade = this.getUpgrade();
        return !this.getUpgrade().m_41619_() && upgrade.m_41720_() == ForceRegistry.EXPERIENCE_CORE.get();
    }

    public int getSpeed() {
        return this.isFast() ? 10 : 2;
    }

    public int getXPMultiplier() {
        return this.hasXPMultiplied() ? 2 : 1;
    }

    protected AbstractCookingRecipe getRecipe() {
        ItemStack input = this.m_8020_(0);
        if (input.m_41619_() || input == this.failedMatch || this.f_58857_ == null) {
            return null;
        }
        if (this.currentRecipe != null && this.currentRecipe.m_5818_((Container)this, this.f_58857_) && this.currentRecipe.m_6671_() == this.getRecipeType()) {
            return this.currentRecipe;
        }
        AbstractCookingRecipe rec = this.f_58857_.m_7465_().m_44015_(this.getRecipeType(), (Container)this, this.f_58857_).orElse(null);
        this.failedMatch = rec == null ? input : ItemStack.f_41583_;
        this.currentRecipe = rec;
        return this.currentRecipe;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.upgradeHandler.deserializeNBT(nbt.m_128469_("UpgradeHandler"));
        this.handler.deserializeNBT(nbt.m_128469_("ItemStackHandler"));
        this.litTime = nbt.m_128451_("BurnTime");
        this.burnSpeed = nbt.m_128451_("BurnSpeed");
        this.cookingProgress = nbt.m_128451_("CookTime");
        this.cookingTotalTime = nbt.m_128451_("CookTimeTotal");
        this.litDuration = nbt.m_128441_("BurnTimeTotal") ? nbt.m_128451_("BurnTimeTotal") : this.getBurnDuration(this.handler.getStackInSlot(1));
        this.cookingSpeed = nbt.m_128451_("CookSpeed");
        CompoundTag recipesUsed = nbt.m_128469_("RecipesUsed");
        for (String s : recipesUsed.m_128431_()) {
            this.recipes.put((Object)new ResourceLocation(s), recipesUsed.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("BurnTime", this.litTime);
        compound.m_128405_("BurnSpeed", this.burnSpeed);
        compound.m_128405_("CookTime", this.cookingProgress);
        compound.m_128405_("CookTimeTotal", this.cookingTotalTime);
        compound.m_128405_("BurnTimeTotal", this.litDuration);
        compound.m_128405_("CookSpeed", this.cookingSpeed);
        compound.m_128365_("UpgradeHandler", (Tag)this.upgradeHandler.serializeNBT());
        compound.m_128365_("ItemStackHandler", (Tag)this.handler.serializeNBT());
        CompoundTag recipesUsed = new CompoundTag();
        this.recipes.forEach((recipeId, craftedAmount) -> recipesUsed.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)recipesUsed);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractForceFurnaceBlockEntity furnace) {
        boolean wasBurning = furnace.isLit();
        if (furnace.isLit() && furnace.canBurn((Recipe<?>)furnace.currentRecipe)) {
            int speed = furnace.getSpeed();
            if (furnace.burnSpeed != speed) {
                furnace.burnSpeed = speed;
            }
            furnace.litTime -= furnace.burnSpeed;
        }
        if (level != null) {
            boolean dirty = false;
            ItemStack fuel = furnace.handler.getStackInSlot(1);
            if (furnace.isLit() || !fuel.m_41619_() && !furnace.handler.getStackInSlot(0).m_41619_()) {
                AbstractCookingRecipe cookingRecipe = furnace.getRecipe();
                if (!furnace.isLit() && furnace.canBurn((Recipe<?>)cookingRecipe)) {
                    furnace.litDuration = furnace.litTime = furnace.getBurnDuration(fuel);
                    if (furnace.isLit()) {
                        dirty = true;
                        if (fuel.hasCraftingRemainingItem()) {
                            furnace.handler.setStackInSlot(1, fuel.getCraftingRemainingItem());
                        } else if (!fuel.m_41619_()) {
                            fuel.m_41774_(1);
                            if (fuel.m_41619_()) {
                                furnace.handler.setStackInSlot(1, fuel.getCraftingRemainingItem());
                            }
                        }
                    }
                }
                if (furnace.isLit() && furnace.canBurn((Recipe<?>)cookingRecipe)) {
                    int speed;
                    int n = speed = furnace.isEfficient() ? 4 : furnace.getSpeed();
                    if (furnace.cookingSpeed != speed) {
                        furnace.cookingSpeed = speed;
                    }
                    if (cookingRecipe != null && furnace.cookingTotalTime != cookingRecipe.m_43753_()) {
                        furnace.cookingTotalTime = cookingRecipe.m_43753_();
                    }
                    furnace.cookingProgress += furnace.cookingSpeed;
                    if (furnace.cookingProgress >= furnace.cookingTotalTime) {
                        furnace.cookingProgress = 0;
                        furnace.cookingTotalTime = furnace.getCookingProgress();
                        if (furnace.burn((Recipe<?>)cookingRecipe)) {
                            furnace.m_6029_((Recipe<?>)cookingRecipe);
                        }
                        dirty = true;
                    }
                } else {
                    furnace.cookingProgress = 0;
                }
            } else if (!furnace.isLit() && furnace.cookingProgress > 0) {
                furnace.cookingProgress = Mth.m_14045_((int)(furnace.cookingProgress - 2), (int)0, (int)furnace.cookingTotalTime);
            }
            if (wasBurning != furnace.isLit()) {
                dirty = true;
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(furnace.isLit())), 3);
            }
            if (dirty) {
                AbstractForceFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    protected boolean canBurn(@Nullable Recipe<?> recipeIn) {
        if (!this.handler.getStackInSlot(0).m_41619_() && recipeIn != null) {
            ItemStack recipeOutput = recipeIn.m_8043_();
            if (recipeOutput.m_41619_()) {
                return false;
            }
            ItemStack output = this.handler.getStackInSlot(2);
            if (output.m_41619_()) {
                return true;
            }
            if (!output.m_41656_(recipeOutput)) {
                return false;
            }
            if (output.m_41613_() + recipeOutput.m_41613_() <= this.m_6893_() && output.m_41613_() + recipeOutput.m_41613_() <= output.m_41741_()) {
                return true;
            }
            return output.m_41613_() + recipeOutput.m_41613_() <= recipeOutput.m_41741_();
        }
        return false;
    }

    private boolean burn(@Nullable Recipe<?> recipe) {
        if (recipe != null && this.canBurn(recipe) && this.f_58857_ != null) {
            ItemStack itemstack = this.handler.getStackInSlot(0);
            List additionalBlacklist = new ArrayList();
            if (ConfigHandler.COMMON.furnaceOutputBlacklist.get() != null && !((List)ConfigHandler.COMMON.furnaceOutputBlacklist.get()).isEmpty() && !((String)((List)ConfigHandler.COMMON.furnaceOutputBlacklist.get()).get(0)).isEmpty()) {
                additionalBlacklist = (List)ConfigHandler.COMMON.furnaceOutputBlacklist.get();
            }
            if (recipe instanceof MultipleOutputFurnaceRecipe) {
                MultipleOutputFurnaceRecipe multipleRecipe = (MultipleOutputFurnaceRecipe)recipe;
                NonNullList<ItemStack> outputStacks = multipleRecipe.getRecipeOutputs();
                for (int i = 0; i < outputStacks.size(); ++i) {
                    ItemStack outputStack = ((ItemStack)outputStacks.get(i)).m_41777_();
                    if (i <= 0 || multipleRecipe.getSecondaryChance() == 1.0f && !(this.f_58857_.f_46441_.m_188501_() > multipleRecipe.getSecondaryChance())) {
                        BiggestInventory inventory;
                        IItemHandler itemHandler;
                        ArrayList<BiggestInventory> inventoryList2 = new ArrayList<BiggestInventory>();
                        for (Direction dir : Direction.values()) {
                            IItemHandler itemHandler2;
                            boolean flag2;
                            BlockEntity foundTile;
                            BlockPos offPos = this.f_58858_.m_121945_(dir);
                            if (!this.f_58857_.isAreaLoaded(this.f_58858_, 1) || (foundTile = this.f_58857_.m_7702_(offPos)) == null) continue;
                            ResourceLocation typeLocation = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)foundTile.m_58903_());
                            boolean flag = foundTile instanceof Hopper || foundTile instanceof AbstractFurnaceBlockEntity || foundTile instanceof AbstractForceFurnaceBlockEntity;
                            boolean bl = flag2 = typeLocation != null && !hopperBlacklist.contains(typeLocation) && (additionalBlacklist.isEmpty() || !additionalBlacklist.contains(typeLocation.toString()));
                            if (flag || !flag2 || foundTile.m_58901_() || !foundTile.m_58898_() || !foundTile.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() || (itemHandler2 = (IItemHandler)foundTile.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).orElse(null)) == null) continue;
                            inventoryList2.add(new BiggestInventory(offPos, itemHandler2.getSlots(), dir.m_122424_()));
                        }
                        inventoryList2.sort(Collections.reverseOrder());
                        Iterator iterator = inventoryList2.iterator();
                        while (iterator.hasNext() && !(outputStack = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (inventory = (BiggestInventory)iterator.next()).getIItemHandler(this.f_58857_)), (ItemStack)outputStack, (boolean)false)).m_41619_()) {
                        }
                        if (i > 0 && !outputStack.m_41619_()) {
                            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_(), 1, 0.0, 0.0, 0.0, 0.0);
                            ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)(this.m_58899_().m_123342_() + 1), (double)this.m_58899_().m_123343_(), outputStack);
                            this.f_58857_.m_7967_((Entity)itemEntity);
                            continue;
                        }
                        ItemStack currentOutputStack = this.handler.getStackInSlot(2);
                        if (currentOutputStack.m_41619_() && !outputStack.m_41619_()) {
                            this.handler.setStackInSlot(2, outputStack);
                            continue;
                        }
                        if (currentOutputStack.m_41720_() != ((ItemStack)outputStacks.get(i)).m_41720_()) continue;
                        currentOutputStack.m_41769_(outputStack.m_41613_());
                        continue;
                    }
                    break;
                }
            } else {
                BiggestInventory inventory;
                IItemHandler itemHandler;
                ItemStack itemstack1 = recipe.m_8043_();
                ItemStack outputStack = itemstack1.m_41777_();
                ArrayList<BiggestInventory> inventoryList = new ArrayList<BiggestInventory>();
                for (Direction dir : Direction.values()) {
                    IItemHandler itemHandler3;
                    boolean flag2;
                    BlockEntity foundTile;
                    BlockPos offPos = this.f_58858_.m_121945_(dir);
                    if (!this.f_58857_.isAreaLoaded(this.f_58858_, 1) || (foundTile = this.f_58857_.m_7702_(offPos)) == null) continue;
                    ResourceLocation typeLocation = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)foundTile.m_58903_());
                    boolean flag = foundTile instanceof Hopper || foundTile instanceof AbstractFurnaceBlockEntity || foundTile instanceof AbstractForceFurnaceBlockEntity;
                    boolean bl = flag2 = typeLocation != null && !hopperBlacklist.contains(typeLocation) && (additionalBlacklist.isEmpty() || !additionalBlacklist.contains(typeLocation.toString()));
                    if (flag || !flag2 || foundTile.m_58901_() || !foundTile.m_58898_() || !foundTile.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() || (itemHandler3 = (IItemHandler)foundTile.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).orElse(null)) == null) continue;
                    inventoryList.add(new BiggestInventory(offPos, itemHandler3.getSlots(), dir.m_122424_()));
                }
                inventoryList.sort(Collections.reverseOrder());
                Iterator inventoryList2 = inventoryList.iterator();
                while (inventoryList2.hasNext() && !(outputStack = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (inventory = (BiggestInventory)inventoryList2.next()).getIItemHandler(this.f_58857_)), (ItemStack)outputStack, (boolean)false)).m_41619_()) {
                }
                ItemStack itemstack2 = this.handler.getStackInSlot(2);
                if (itemstack2.m_41619_() && !outputStack.m_41619_()) {
                    this.handler.setStackInSlot(2, outputStack);
                } else if (itemstack2.m_41720_() == itemstack1.m_41720_()) {
                    itemstack2.m_41769_(outputStack.m_41613_());
                }
            }
            if (!this.f_58857_.f_46443_) {
                this.m_6029_(recipe);
            }
            if (itemstack.m_41720_() == Blocks.f_50057_.m_5456_() && !this.handler.getStackInSlot(1).m_41619_() && this.handler.getStackInSlot(1).m_41720_() == Items.f_42446_) {
                this.handler.setStackInSlot(1, new ItemStack((ItemLike)Items.f_42447_));
            }
            itemstack.m_41774_(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(ItemStack fuel) {
        if (fuel.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)fuel, null);
    }

    protected int getCookingProgress() {
        if (this.f_58857_ == null) {
            return 200;
        }
        AbstractCookingRecipe rec = this.getRecipe();
        if (rec == null) {
            return 200;
        }
        return this.f_58857_.m_7465_().m_44015_(this.getRecipeType(), (Container)this, this.f_58857_).map(AbstractCookingRecipe::m_43753_).orElse(100);
    }

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index == 1) {
            Item item = stack.m_41720_();
            return item == Items.f_42447_ || item == Items.f_42446_;
        }
        return true;
    }

    public int m_6643_() {
        return this.handler.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return this.handler.getStackInSlot(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ItemHandlerUtils.getAndSplit((IItemHandler)this.handler, index, count);
    }

    public ItemStack m_8016_(int index) {
        return ItemHandlerUtils.getAndRemove((IItemHandler)this.handler, index);
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack itemstack = this.handler.getStackInSlot(index);
        boolean flag = this.handler.isItemValid(index, stack) && !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        this.handler.setStackInSlot(index, stack);
        if (stack.m_41613_() > this.handler.getSlotLimit(index)) {
            stack.m_41764_(this.handler.getSlotLimit(index));
        }
        if (index == 0 && !flag) {
            this.cookingTotalTime = this.getCookingProgress();
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.handler.isItemValid(index, stack);
    }

    public void m_6211_() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.m_6423_();
            this.recipes.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_8015_(Player player) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(player.m_9236_(), player.m_20182_());
        player.m_7281_(list);
        this.recipes.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel serverLevel, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
            serverLevel.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                AbstractForceFurnaceBlockEntity.createExperience(serverLevel, pos, entry.getIntValue(), ((AbstractCookingRecipe)recipe).m_43750_() * (float)this.getXPMultiplier());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel serverLevel, Vec3 pos, int craftedAmount, float experience) {
        int i = Mth.m_14143_((float)((float)craftedAmount * experience));
        float f = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)pos, (int)i);
    }

    public void m_5809_(StackedContents helper) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            helper.m_36491_(this.handler.getStackInSlot(i));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
        this.handlerHolder.invalidate();
        this.upgradeHandlerHolder.invalidate();
    }

    public ContainerData getFurnaceData() {
        return this.furnaceData;
    }

    private class BiggestInventory
    implements Comparable<BiggestInventory> {
        private final int inventorySize;
        private final BlockPos tilePos;
        private final Direction direction;

        public BiggestInventory(BlockPos pos, int size, Direction dir) {
            this.tilePos = pos;
            this.inventorySize = size;
            this.direction = dir;
        }

        protected IItemHandler getIItemHandler(Level level) {
            BlockEntity tileEntity;
            if (level.isAreaLoaded(AbstractForceFurnaceBlockEntity.this.f_58858_, 1) && !(tileEntity = level.m_7702_(this.tilePos)).m_58901_() && tileEntity.m_58898_() && tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                return (IItemHandler)tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, this.direction).orElse(null);
            }
            return null;
        }

        @Override
        public int compareTo(BiggestInventory otherInventory) {
            return Integer.compare(this.inventorySize, otherInventory.inventorySize);
        }
    }
}

