/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbessentials.FTBEssentialsEvents;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;

public class TeleportCommands {
    public static final TagKey<Block> IGNORE_RTP = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("ftbessentials", "ignore_rtp"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (FTBEConfig.BACK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"back").requires((Predicate)FTBEConfig.BACK)).executes(context -> TeleportCommands.back(((CommandSourceStack)context.getSource()).m_81375_())));
        }
        if (FTBEConfig.SPAWN.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").requires((Predicate)FTBEConfig.SPAWN)).executes(context -> TeleportCommands.spawn(((CommandSourceStack)context.getSource()).m_81375_())));
        }
        if (FTBEConfig.RTP.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtp").requires((Predicate)FTBEConfig.RTP)).executes(context -> TeleportCommands.rtp(((CommandSourceStack)context.getSource()).m_81375_())));
        }
        if (FTBEConfig.TPL.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"teleport_last").requires(FTBEConfig.TPL.enabledAndOp())).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).executes(context -> TeleportCommands.tpLast(((CommandSourceStack)context.getSource()).m_81375_(), (GameProfile)GameProfileArgument.m_94590_((CommandContext)context, (String)"player").iterator().next()))));
        }
        if (FTBEConfig.TPX.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpx").requires(FTBEConfig.TPX.enabledAndOp())).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> TeleportCommands.tpx(((CommandSourceStack)context.getSource()).m_81375_(), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension")))));
        }
    }

    public static int back(ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        if (data.teleportHistory.isEmpty()) {
            player.m_5661_((Component)Component.m_237113_((String)"Teleportation history is empty!").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (data.backTeleporter.teleport(player, serverPlayerEntity -> data.teleportHistory.getLast()).runCommand(player) != 0) {
            data.markDirty();
            return 1;
        }
        return 0;
    }

    public static int spawn(ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        ServerLevel w = player.f_8924_.m_129880_(Level.f_46428_);
        if (w == null) {
            return 0;
        }
        return data.spawnTeleporter.teleport(player, p -> new TeleportPos((Level)w, w.m_220360_())).runCommand(player);
    }

    public static int rtp(ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        return data.rtpTeleporter.teleport(player, p -> {
            p.m_5661_((Component)Component.m_237113_((String)"Looking for random location..."), false);
            return TeleportCommands.findBlockPos(player.m_9236_(), p, 1);
        }).runCommand(player);
    }

    private static TeleportPos findBlockPos(ServerLevel world, ServerPlayer player, int attempt) {
        if (attempt > (Integer)FTBEConfig.RTP_MAX_TRIES.get()) {
            player.m_5661_((Component)Component.m_237113_((String)"Could not find a valid location to teleport to!").m_130940_(ChatFormatting.RED), false);
            return new TeleportPos((Entity)player);
        }
        double dist = (double)((Integer)FTBEConfig.RTP_MIN_DISTANCE.get()).intValue() + world.f_46441_.m_188500_() * (double)((Integer)FTBEConfig.RTP_MAX_DISTANCE.get() - (Integer)FTBEConfig.RTP_MIN_DISTANCE.get());
        double angle = world.f_46441_.m_188500_() * Math.PI * 2.0;
        int x = Mth.m_14107_((double)(Math.cos(angle) * dist));
        int y = 256;
        int z = Mth.m_14107_((double)(Math.sin(angle) * dist));
        BlockPos currentPos = new BlockPos(x, y, z);
        WorldBorder border = world.m_6857_();
        if (!border.m_61937_(currentPos)) {
            return TeleportCommands.findBlockPos(world, player, attempt + 1);
        }
        Holder biomeKey = world.m_204166_(currentPos);
        if (biomeKey.m_203543_().isPresent() && ((ResourceKey)biomeKey.m_203543_().get()).m_135782_().m_135815_().contains("ocean")) {
            return TeleportCommands.findBlockPos(world, player, attempt + 1);
        }
        EventResult res = ((FTBEssentialsEvents.RTP)FTBEssentialsEvents.RTP_EVENT.invoker()).teleport(world, player, currentPos, attempt);
        if (res.isFalse()) {
            return TeleportCommands.findBlockPos(world, player, attempt + 1);
        }
        world.m_46819_(currentPos.m_123341_() >> 4, currentPos.m_123343_() >> 4, ChunkStatus.f_62325_);
        BlockPos hmPos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, currentPos);
        if (hmPos.m_123342_() > 0) {
            if (hmPos.m_123342_() >= world.m_143344_()) {
                for (BlockPos newPos : BlockPos.m_121935_((BlockPos)new BlockPos(hmPos.m_123341_(), world.m_5736_(), hmPos.m_123342_()), (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
                    BlockState bs = world.m_8055_(newPos);
                    if (!bs.m_60767_().m_76337_() || bs.m_204336_(IGNORE_RTP) || !world.m_46859_(newPos.m_6630_(1)) || !world.m_46859_(newPos.m_6630_(2)) || !world.m_46859_(newPos.m_6630_(3))) continue;
                    player.m_5661_((Component)Component.m_237113_((String)String.format("Found good location after %d " + (attempt == 1 ? "attempt" : "attempts") + " @ [x %d, z %d]", attempt, newPos.m_123341_(), newPos.m_123343_())), false);
                    return new TeleportPos((ResourceKey<Level>)world.m_46472_(), newPos.m_7494_());
                }
            } else {
                player.m_5661_((Component)Component.m_237113_((String)String.format("Found good location after %d " + (attempt == 1 ? "attempt" : "attempts") + " @ [x %d, z %d]", attempt, hmPos.m_123341_(), hmPos.m_123343_())), false);
                return new TeleportPos((ResourceKey<Level>)world.m_46472_(), hmPos.m_7494_());
            }
        }
        return TeleportCommands.findBlockPos(world, player, attempt + 1);
    }

    public static int tpLast(ServerPlayer player, GameProfile to) {
        ServerPlayer p = player.f_8924_.m_6846_().m_11259_(to.getId());
        if (p != null) {
            FTBEPlayerData.addTeleportHistory(player);
            new TeleportPos((Entity)p).teleport(player);
            return 1;
        }
        FTBEPlayerData dataTo = FTBEPlayerData.get(to);
        if (dataTo == null) {
            return 0;
        }
        FTBEPlayerData.addTeleportHistory(player);
        dataTo.lastSeen.teleport(player);
        return 1;
    }

    public static int tpx(ServerPlayer player, ServerLevel to) {
        player.m_8999_(to, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
        return 1;
    }
}

