/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.mojang.math.Matrix4f;
import java.nio.FloatBuffer;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shadow.ShadowMatrices;
import net.coderbot.iris.uniforms.CapturedRenderingState;

public final class MatrixUniforms {
    private MatrixUniforms() {
    }

    public static void addMatrixUniforms(UniformHolder uniforms, PackDirectives directives) {
        MatrixUniforms.addMatrix(uniforms, "ModelView", CapturedRenderingState.INSTANCE::getGbufferModelView);
        MatrixUniforms.addMatrix(uniforms, "Projection", CapturedRenderingState.INSTANCE::getGbufferProjection);
        MatrixUniforms.addShadowMatrix(uniforms, "ModelView", () -> ShadowRenderer.createShadowModelView(directives.getSunPathRotation(), directives.getShadowDirectives().getIntervalSize()).m_85850_().m_85861_().m_27658_());
        MatrixUniforms.addShadowArrayMatrix(uniforms, "Projection", () -> ShadowMatrices.createOrthoMatrix(directives.getShadowDirectives().getDistance()));
    }

    private static void addMatrix(UniformHolder uniforms, String name, Supplier<Matrix4f> supplier) {
        uniforms.uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbuffer" + name, supplier).uniformJomlMatrix(UniformUpdateFrequency.PER_FRAME, "gbuffer" + name + "Inverse", new Inverted(supplier)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbufferPrevious" + name, new Previous(supplier));
    }

    private static void addShadowMatrix(UniformHolder uniforms, String name, Supplier<Matrix4f> supplier) {
        uniforms.uniformMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + name, supplier).uniformJomlMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + name + "Inverse", new Inverted(supplier));
    }

    private static void addShadowArrayMatrix(UniformHolder uniforms, String name, Supplier<float[]> supplier) {
        uniforms.uniformMatrixFromArray(UniformUpdateFrequency.PER_FRAME, "shadow" + name, supplier).uniformJomlMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + name + "Inverse", new InvertedArrayMatrix(supplier));
    }

    private static class Inverted
    implements Supplier<net.coderbot.iris.vendored.joml.Matrix4f> {
        private final Supplier<Matrix4f> parent;

        Inverted(Supplier<Matrix4f> parent) {
            this.parent = parent;
        }

        @Override
        public net.coderbot.iris.vendored.joml.Matrix4f get() {
            Matrix4f copy = this.parent.get().m_27658_();
            FloatBuffer buffer = FloatBuffer.allocate(16);
            copy.m_27650_(buffer);
            buffer.rewind();
            net.coderbot.iris.vendored.joml.Matrix4f matrix4f = new net.coderbot.iris.vendored.joml.Matrix4f(buffer);
            matrix4f.invert();
            return matrix4f;
        }
    }

    private static class Previous
    implements Supplier<Matrix4f> {
        private final Supplier<Matrix4f> parent;
        private Matrix4f previous;

        Previous(Supplier<Matrix4f> parent) {
            this.parent = parent;
            this.previous = new Matrix4f();
        }

        @Override
        public Matrix4f get() {
            Matrix4f copy = this.parent.get().m_27658_();
            Matrix4f previous = this.previous.m_27658_();
            this.previous = copy;
            return previous;
        }
    }

    private static class InvertedArrayMatrix
    implements Supplier<net.coderbot.iris.vendored.joml.Matrix4f> {
        private final Supplier<float[]> parent;

        InvertedArrayMatrix(Supplier<float[]> parent) {
            this.parent = parent;
        }

        @Override
        public net.coderbot.iris.vendored.joml.Matrix4f get() {
            FloatBuffer buffer = FloatBuffer.allocate(16);
            buffer.put(this.parent.get());
            buffer.rewind();
            net.coderbot.iris.vendored.joml.Matrix4f matrix4f = new net.coderbot.iris.vendored.joml.Matrix4f(buffer);
            matrix4f.invert();
            return matrix4f;
        }
    }
}

