/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.logical;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.logical.AbstractListBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.AnyBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.NoneBlockPredicate;

public final class AndBlockPredicate
extends AbstractListBlockPredicate {
    public static final String NAME = "and";
    public static final Codec<AndBlockPredicate> CODEC = AndBlockPredicate.codec(AndBlockPredicate::new);

    public AndBlockPredicate(IBlockPosPredicate ... predicates) {
        this(Arrays.asList(predicates));
    }

    public AndBlockPredicate(Iterable<IBlockPosPredicate> predicates) {
        super(predicates);
    }

    @Override
    public boolean test(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nullable Direction direction) {
        return this.predicates.stream().allMatch(predicate -> predicate.test(level, pos, direction));
    }

    public BlockPosPredicateType<AndBlockPredicate> getType() {
        return (BlockPosPredicateType)BlockPosPredicateType.AND.get();
    }

    @Override
    public IBlockPosPredicate and(IBlockPosPredicate ... predicates) {
        return new AndBlockPredicate(this.merge(List.of(predicates), AndBlockPredicate.class));
    }

    @Override
    public IBlockPosPredicate simplify() {
        List<IBlockPosPredicate> simplified;
        block5: {
            block4: {
                simplified = this.predicates.stream().map(IBlockPosPredicate::simplify).flatMap(p -> {
                    Stream<IBlockPosPredicate> stream;
                    if (p instanceof AndBlockPredicate) {
                        AndBlockPredicate andBlockPredicate = (AndBlockPredicate)p;
                        stream = andBlockPredicate.predicates.stream();
                    } else {
                        stream = Stream.of(p);
                    }
                    return stream;
                }).filter(p -> !(p instanceof AnyBlockPredicate)).toList();
                if (simplified.isEmpty()) break block4;
                if (!simplified.stream().anyMatch(NoneBlockPredicate.class::isInstance)) break block5;
            }
            return IBlockPosPredicate.none();
        }
        if (simplified.size() == 1) {
            return simplified.get(0);
        }
        return new AndBlockPredicate(simplified);
    }
}

