/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items.modules;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelTileEntity;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.RedstoneScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.RedstoneClientScreenModule;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RedstoneModuleItem
extends GenericModuleItem {
    public RedstoneModuleItem() {
        super(RFToolsUtility.setup.defaultProperties().m_41487_(1).m_41499_(1));
    }

    protected int getUses(ItemStack stack) {
        return (Integer)ScreenConfiguration.REDSTONE_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public void m_7373_(@Nonnull ItemStack itemStack, @Nullable Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_("channel")) {
            int channel = tag.m_128451_("channel");
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "Channel: " + channel)));
        }
    }

    public Class<RedstoneScreenModule> getServerScreenModule() {
        return RedstoneScreenModule.class;
    }

    public Class<RedstoneClientScreenModule> getClientScreenModule() {
        return RedstoneClientScreenModule.class;
    }

    public String getModuleName() {
        return "Red";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text("text", new String[]{"Label text"}).color("color", new String[]{"Color for the label"}).nl().label("Yes:").text("yestext", new String[]{"Positive text"}).color("yescolor", new String[]{"Color for the positive text"}).nl().label("No:").text("notext", new String[]{"Negative text"}).color("nocolor", new String[]{"Color for the negative text"}).nl().choices("align", "Label alignment", new String[]{"Left", "Center", "Right"}).toggle("analog", "Analog mode", new String[]{"Whether to show the exact level"}).nl().label("Block:").block("monitor").nl();
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        BlockEntity te = world.m_7702_(pos);
        Player player = context.m_43723_();
        Direction facing = context.m_43719_();
        CompoundTag tagCompound = stack.m_41784_();
        int channel = -1;
        if (!(te instanceof RedstoneChannelTileEntity)) {
            tagCompound.m_128405_("channel", -1);
            tagCompound.m_128359_("monitordim", world.m_46472_().m_135782_().toString());
            tagCompound.m_128405_("monitorx", pos.m_123341_());
            tagCompound.m_128405_("monitory", pos.m_123342_());
            tagCompound.m_128405_("monitorz", pos.m_123343_());
            tagCompound.m_128405_("monitorside", facing.ordinal());
            Logging.message((Player)player, (String)("Redstone module is set to " + pos));
            return InteractionResult.SUCCESS;
        }
        channel = ((RedstoneChannelTileEntity)te).getChannel(true);
        ModuleTools.clearPositionInModule((ItemStack)stack);
        if (channel != -1) {
            tagCompound.m_128405_("channel", channel);
            Logging.message((Player)player, (String)("Redstone module is set to channel '" + channel + "'"));
        } else {
            tagCompound.m_128473_("channel");
            Logging.message((Player)player, (String)"Redstone module is cleared");
        }
        return InteractionResult.SUCCESS;
    }
}

