/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;

public class EnvironmentalRenderer
implements BlockEntityRenderer<EnvironmentalControllerTileEntity> {
    public static final ResourceLocation HALO = new ResourceLocation("rftoolsutility", "block/effects/floatingsphere");
    private static final Random random = new Random();
    private static final List<EnvironmentalControllerTileEntity> toRender = new ArrayList<EnvironmentalControllerTileEntity>();
    private static final RenderSettings RENDER_SETTINGS = RenderSettings.builder().color(255, 255, 255).renderType(CustomRenderTypes.TRANSLUCENT_LIGHTNING_NOLIGHTMAPS).alpha(128).build();

    public EnvironmentalRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(EnvironmentalControllerTileEntity te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.isActive()) {
            toRender.add(te);
        }
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)EnvironmentalModule.TYPE_ENVIRONENTAL_CONTROLLER.get()), EnvironmentalRenderer::new);
    }

    public static void renderEnvironmentals(RenderLevelLastEvent event) {
        if (toRender.isEmpty()) {
            return;
        }
        PoseStack matrixStack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        matrixStack.m_85836_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        for (EnvironmentalControllerTileEntity te : toRender) {
            float s = 0.6f + random.nextFloat() * 0.1f;
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)te.m_58899_().m_123341_(), (double)te.m_58899_().m_123342_(), (double)te.m_58899_().m_123343_());
            RenderHelper.renderBillboardQuadBright((PoseStack)matrixStack, (MultiBufferSource)buffer, (float)s, (ResourceLocation)HALO, (RenderSettings)RenderSettings.builder().color(255, 255, 255).renderType(CustomRenderTypes.TRANSLUCENT_LIGHTNING_NOLIGHTMAPS).alpha(128).build());
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        toRender.clear();
    }
}

