/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.entity;

import ad_astra_giselle_addon.common.entity.LivingHelperDelegate;
import ad_astra_giselle_addon.common.item.ItemStackConsumers;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class LivingHelper {
    private static final Delegate DELEGATE = new LivingHelperDelegate();

    public static boolean isPlayingMode(LivingEntity living) {
        if (living instanceof Player) {
            Player player = (Player)living;
            return !player.m_7500_() && !player.m_5833_();
        }
        return true;
    }

    public static List<ItemStackReference> getSlotItems(LivingEntity living) {
        ArrayList<ItemStackReference> list = new ArrayList<ItemStackReference>();
        for (InteractionHand hand : InteractionHand.values()) {
            list.add(new ItemStackReference(living.m_21120_(hand), ItemStackConsumers.hand(hand, (arg_0, arg_1) -> ((LivingEntity)living).m_21008_(arg_0, arg_1))));
        }
        list.addAll(LivingHelper.getArmorItems(living));
        return list;
    }

    public static List<ItemStackReference> getArmorItems(LivingEntity living) {
        ArrayList<ItemStackReference> list = new ArrayList<ItemStackReference>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            list.add(new ItemStackReference(living.m_6844_(slot), ItemStackConsumers.equipment(slot, (arg_0, arg_1) -> ((LivingEntity)living).m_8061_(arg_0, arg_1))));
        }
        return list;
    }

    public static List<ItemStackReference> getInventoryStacks(LivingEntity living) {
        ArrayList<ItemStackReference> list = new ArrayList<ItemStackReference>();
        if (living instanceof Player) {
            Player player = (Player)living;
            Inventory inventory = player.m_150109_();
            int size = inventory.m_6643_();
            for (int i = 0; i < size; ++i) {
                ItemStack item = inventory.m_8020_(i);
                if (item.m_41619_()) continue;
                list.add(new ItemStackReference(item, ItemStackConsumers.index(i, (arg_0, arg_1) -> ((Inventory)inventory).m_6836_(arg_0, arg_1))));
            }
        } else {
            list.addAll(LivingHelper.getSlotItems(living));
        }
        list.addAll(DELEGATE.getExtraInventoryStacks(living));
        return list;
    }

    public static interface Delegate {
        default public List<ItemStackReference> getExtraInventoryStacks(LivingEntity living) {
            return Collections.emptyList();
        }
    }
}

