/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.proof;

import ad_astra_giselle_addon.common.config.EnchantmentsConfig;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.content.proof.ProofAbstractUtils;
import ad_astra_giselle_addon.common.content.proof.ProofEnchantmentSession;
import ad_astra_giselle_addon.common.enchantment.AddonEnchantment;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import ad_astra_giselle_addon.common.item.ItemUsableResource;
import net.minecraft.world.entity.LivingEntity;

public class SpaceOxygenProofEnchantmentSession
extends ProofEnchantmentSession {
    private IOxygenCharger testedOxygenCharger;

    public SpaceOxygenProofEnchantmentSession(LivingEntity living, AddonEnchantment enchantment) {
        super(living, enchantment);
    }

    @Override
    public boolean canProvide() {
        if (!super.canProvide()) {
            return false;
        }
        LivingEntity entity = this.getLiving();
        if (LivingHelper.isPlayingMode(entity)) {
            long oxygenUsing = this.getOxygenUsing();
            IOxygenCharger oxygenCharger = OxygenChargerUtils.firstExtractable(entity, oxygenUsing);
            if (oxygenCharger == null) {
                return false;
            }
            UniveralFluidHandler fluidHandler = oxygenCharger.getFluidHandler();
            if (FluidHooks2.extractFluid(fluidHandler, FluidPredicates::isOxygen, oxygenUsing, true).getFluidAmount() < oxygenUsing) {
                return false;
            }
            this.testedOxygenCharger = oxygenCharger;
        }
        return true;
    }

    @Override
    public void onProvide() {
        IOxygenCharger oxygenCharger;
        super.onProvide();
        LivingEntity entity = this.getLiving();
        if (LivingHelper.isPlayingMode(entity) && (oxygenCharger = this.testedOxygenCharger) != null && !entity.m_9236_().m_5776_()) {
            UniveralFluidHandler fluidHandler = oxygenCharger.getFluidHandler();
            long oxygenUsing = this.getOxygenUsing();
            FluidHooks2.extractFluid(fluidHandler, FluidPredicates::isOxygen, oxygenUsing, false);
        }
    }

    @Override
    public long getResourceUsingAmount(ItemUsableResource resource) {
        if (resource == ItemUsableResource.Energy) {
            return EnchantmentsConfig.SPACE_BREATHING_ENERGY_USING;
        }
        if (resource == ItemUsableResource.Durability) {
            return EnchantmentsConfig.SPACE_BREATHING_DURABILITY_USING;
        }
        return 0L;
    }

    @Override
    public int getProofDuration(ItemUsableResource resource) {
        if (resource == ItemUsableResource.Energy) {
            return 30;
        }
        if (resource == ItemUsableResource.Durability) {
            return EnchantmentsConfig.SPACE_BREATHING_DURABILITY_DURATION;
        }
        return 0;
    }

    public long getOxygenUsing() {
        ItemUsableResource resource = this.getTestedUsableResource();
        return this.getOxygenUsing(resource);
    }

    public long getOxygenUsing(ItemUsableResource resource) {
        if (resource == ItemUsableResource.Energy) {
            return ProofAbstractUtils.OXYGEN_PROOF_USING;
        }
        if (resource == ItemUsableResource.Durability) {
            return EnchantmentsConfig.SPACE_BREATHING_DURABILITY_OXYGEN;
        }
        return 0L;
    }
}

