/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.content.oxygen.ChargeMode;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import java.util.List;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IChargeMode {
    public static final String LANGUGE_CATEGORY_CHARGEMODE = "chargemode";

    @NotNull
    public static IChargeMode find(@Nullable List<IChargeMode> availableModes, @Nullable String name) {
        if (name == null) {
            return ChargeMode.NONE;
        }
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)name);
        return IChargeMode.find(availableModes, resourceLocation);
    }

    @NotNull
    public static IChargeMode find(@Nullable List<IChargeMode> availableModes, @Nullable ResourceLocation name) {
        if (availableModes == null || name == null) {
            return ChargeMode.NONE;
        }
        for (IChargeMode mode : availableModes) {
            if (!mode.getName().equals((Object)name)) continue;
            return mode;
        }
        return ChargeMode.NONE;
    }

    public static Tag writeNBT(@Nullable IChargeMode mode) {
        ResourceLocation name = (mode != null ? mode : ChargeMode.NONE).getName();
        return StringTag.m_129297_((String)name.toString());
    }

    @NotNull
    public static IChargeMode readNBT(@Nullable List<IChargeMode> availableModes, @Nullable Tag tag) {
        if (tag == null) {
            return ChargeMode.NONE;
        }
        ResourceLocation name = ResourceLocation.m_135820_((String)tag.m_7916_());
        return IChargeMode.find(availableModes, name);
    }

    public static Component createDisplayName(ResourceLocation name) {
        return Component.m_237115_((String)AdAstraGiselleAddon.tl(LANGUGE_CATEGORY_CHARGEMODE, name));
    }

    public ResourceLocation getName();

    public Component getDisplayName();

    public List<ItemStackReference> getItems(LivingEntity var1);
}

