/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.screen;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.block.entity.IWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.compat.CompatibleManager;
import ad_astra_giselle_addon.common.network.AddonNetwork;
import ad_astra_giselle_addon.common.network.WorkingAreaVisibleMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.ad_astra.client.screen.AbstractMachineScreen;
import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.screen.menu.AbstractMachineMenu;
import java.text.NumberFormat;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class AddonMachineScreen<BLOCK_ENTITY extends AbstractMachineBlockEntity, MENU extends AbstractMachineMenu<BLOCK_ENTITY>>
extends AbstractMachineScreen<BLOCK_ENTITY, MENU> {
    public static final String WORKINGAREA_TEXT_PREFIX = AddonMachineScreen.ctl("workingarea.");
    public static final String WORKINGAREA_TEXT_KEY = WORKINGAREA_TEXT_PREFIX + "text";
    public static final ResourceLocation WORKINGAREA_MIDDLE_TEXTURE = AdAstraGiselleAddon.rl("textures/gui/workingarea_middle.png");
    public static final ResourceLocation WORKINGAREA_SIDE_TEXTURE = AdAstraGiselleAddon.rl("textures/gui/workingarea_side.png");
    private boolean cachedWorkingAreaVisible;
    private Button workingAreaVisibleButton;

    public static String ctl(String path) {
        return AdAstraGiselleAddon.tl("gui", path);
    }

    public static boolean shouldShowRecipeTooltip() {
        return !CompatibleManager.JEI.isLoaded() && !CompatibleManager.REI.isLoaded();
    }

    public AddonMachineScreen(MENU handler, Inventory inventory, Component title, ResourceLocation texture) {
        super(handler, inventory, title, texture);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.hasWorkingArea()) {
            boolean visible;
            this.workingAreaVisibleButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_, this.f_97736_ - 20, 20, 20, (Component)Component.m_237119_(), this::onChangeModeButtonClick));
            this.cachedWorkingAreaVisible = visible = this.isWorkingAreaVisible();
            this.setWorkingAreaVisible(visible);
            this.refreshWorkingAreaVisibleButtonMessage();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        super.m_6305_(poseStack, mouseX, mouseY, delta);
        this.updateWorkingAreaVisibleButton();
    }

    public void resizeWorkingAreaVisibleButton() {
        Button workingAreaVisibleButton = this.getWorkingAreaVisibleButton();
        int messageWidth = workingAreaVisibleButton.m_93694_();
        messageWidth = Math.max(messageWidth, this.f_96547_.m_92852_((FormattedText)this.getWorkingAreaVisibleText(true)));
        messageWidth = Math.max(messageWidth, this.f_96547_.m_92852_((FormattedText)this.getWorkingAreaVisibleText(false)));
        workingAreaVisibleButton.m_93674_(messageWidth + 8);
    }

    public boolean hasWorkingArea() {
        return ((AbstractMachineMenu)this.m_6262_()).getMachine() instanceof IWorkingAreaBlockEntity;
    }

    public boolean isWorkingAreaVisible() {
        IWorkingAreaBlockEntity blockEntity;
        AbstractMachineBlockEntity abstractMachineBlockEntity = ((AbstractMachineMenu)this.m_6262_()).getMachine();
        return abstractMachineBlockEntity instanceof IWorkingAreaBlockEntity && (blockEntity = (IWorkingAreaBlockEntity)abstractMachineBlockEntity).isWorkingAreaVisible();
    }

    @Nullable
    public AABB getWorkingArea() {
        AbstractMachineBlockEntity abstractMachineBlockEntity = ((AbstractMachineMenu)this.m_6262_()).getMachine();
        if (abstractMachineBlockEntity instanceof IWorkingAreaBlockEntity) {
            IWorkingAreaBlockEntity blockEntity = (IWorkingAreaBlockEntity)abstractMachineBlockEntity;
            return blockEntity.getWorkingArea();
        }
        return null;
    }

    public void setWorkingAreaVisible(boolean visible) {
        AbstractMachineBlockEntity machine = ((AbstractMachineMenu)this.m_6262_()).getMachine();
        if (machine instanceof IWorkingAreaBlockEntity) {
            IWorkingAreaBlockEntity blockEntity = (IWorkingAreaBlockEntity)machine;
            blockEntity.setWorkingAreaVisible(visible);
            AddonNetwork.CHANNEL.sendToServer((Packet)new WorkingAreaVisibleMessage(machine.m_58899_(), visible));
        }
    }

    public void onChangeModeButtonClick(Button button) {
        this.setWorkingAreaVisible(!this.isWorkingAreaVisible());
    }

    public void updateWorkingAreaVisibleButton() {
        boolean next = this.isWorkingAreaVisible();
        if (this.cachedWorkingAreaVisible != next) {
            this.cachedWorkingAreaVisible = next;
            this.refreshWorkingAreaVisibleButtonMessage();
        }
    }

    public void refreshWorkingAreaVisibleButtonMessage() {
        Component message = this.getWorkingAreaVisibleText(this.cachedWorkingAreaVisible);
        this.getWorkingAreaVisibleButton().m_93666_(message);
        this.resizeWorkingAreaVisibleButton();
    }

    public Button getWorkingAreaVisibleButton() {
        return this.workingAreaVisibleButton;
    }

    protected void drawWorkingAreaText(PoseStack stack, @Nullable AABB workingArea, AbstractWidget left) {
        if (workingArea == null) {
            return;
        }
        Component workingAreaText = this.getWorkingAreaBoundsText(workingArea);
        int sideWidth = 1;
        int sidePadding = 2;
        int workingAreaWidth = this.f_96547_.m_92852_((FormattedText)workingAreaText) + sidePadding * 2;
        int workingAreaHeight = 11;
        int workingAreaLeft = left.f_93620_ + left.m_5711_() - this.f_97735_;
        int workignAreaTop = -workingAreaHeight;
        int workingAreaOffsetX = workingAreaLeft;
        RenderSystem.m_157456_((int)0, (ResourceLocation)WORKINGAREA_SIDE_TEXTURE);
        GuiComponent.m_93133_((PoseStack)stack, (int)workingAreaOffsetX, (int)workignAreaTop, (float)0.0f, (float)0.0f, (int)sideWidth, (int)workingAreaHeight, (int)sideWidth, (int)workingAreaHeight);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WORKINGAREA_MIDDLE_TEXTURE);
        GuiComponent.m_93133_((PoseStack)stack, (int)(workingAreaOffsetX += sideWidth), (int)workignAreaTop, (float)0.0f, (float)0.0f, (int)workingAreaWidth, (int)workingAreaHeight, (int)workingAreaWidth, (int)workingAreaHeight);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WORKINGAREA_SIDE_TEXTURE);
        GuiComponent.m_93133_((PoseStack)stack, (int)(workingAreaOffsetX += workingAreaWidth), (int)workignAreaTop, (float)0.0f, (float)0.0f, (int)sideWidth, (int)workingAreaHeight, (int)sideWidth, (int)workingAreaHeight);
        workingAreaOffsetX += sideWidth;
        this.f_96547_.m_92889_(stack, workingAreaText, (float)(workingAreaLeft + sideWidth + sidePadding), (float)(workignAreaTop + 2), 0x303030);
    }

    protected Component getWorkingAreaBoundsText(AABB workingArea) {
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        MutableComponent workingAreaText = Component.m_237110_((String)WORKINGAREA_TEXT_KEY, (Object[])new Object[]{numberInstance.format(workingArea.m_82362_()), numberInstance.format(workingArea.m_82376_()), numberInstance.format(workingArea.m_82385_())});
        return workingAreaText;
    }

    protected Component getWorkingAreaVisibleText(boolean visible) {
        String method = visible ? "hide" : "show";
        return Component.m_237115_((String)(WORKINGAREA_TEXT_PREFIX + method));
    }
}

