/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.services;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import com.yungnickyoung.minecraft.travelerstitles.module.ConfigModule;
import com.yungnickyoung.minecraft.travelerstitles.module.SoundModule;
import com.yungnickyoung.minecraft.travelerstitles.render.TitleRenderer;
import com.yungnickyoung.minecraft.travelerstitles.services.IWaystonesCompatHelper;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.KnownWaystonesEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class ForgeWaystonesCompatHelper
implements IWaystonesCompatHelper {
    private List<IWaystone> knownWaystones = new ArrayList<IWaystone>();
    private IWaystone closestWaystone;
    private int waystoneUpdateTimer = 0;
    private final TitleRenderer<IWaystone> waystoneTitleRenderer;

    public ForgeWaystonesCompatHelper() {
        this.waystoneTitleRenderer = new TitleRenderer(TravelersTitlesCommon.CONFIG.waystones.recentWaystoneCacheSize, TravelersTitlesCommon.CONFIG.waystones.enabled, TravelersTitlesCommon.CONFIG.waystones.textFadeInTime, TravelersTitlesCommon.CONFIG.waystones.textDisplayTime, TravelersTitlesCommon.CONFIG.waystones.textFadeOutTime, TravelersTitlesCommon.CONFIG.waystones.textColor, TravelersTitlesCommon.CONFIG.waystones.renderShadow, TravelersTitlesCommon.CONFIG.waystones.textSize, TravelersTitlesCommon.CONFIG.waystones.textXOffset, TravelersTitlesCommon.CONFIG.waystones.textYOffset, TravelersTitlesCommon.CONFIG.waystones.centerText);
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.addListener(this::updateKnownWaystones);
        MinecraftForge.EVENT_BUS.addListener(this::updateClosestWaystone);
    }

    private void updateKnownWaystones(KnownWaystonesEvent event) {
        this.knownWaystones = event.getWaystones();
    }

    private void updateClosestWaystone(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        ++this.waystoneUpdateTimer;
        if (this.waystoneUpdateTimer % 10 == 0) {
            String playerDimension = player.f_19853_.m_46472_().m_135782_().toString();
            BlockPos playerPos = player.m_20183_();
            double minSqDist = Double.MAX_VALUE;
            for (IWaystone waystone : this.knownWaystones) {
                double sqDistance;
                String waystoneDimension = waystone.getDimension().m_135782_().toString();
                if (!waystone.hasName() || !playerDimension.equals(waystoneDimension) || !((sqDistance = waystone.getPos().m_123331_((Vec3i)playerPos)) < minSqDist)) continue;
                minSqDist = sqDistance;
                this.closestWaystone = waystone;
            }
            int range = TravelersTitlesCommon.CONFIG.waystones.range;
            if (minSqDist > (double)(range * range)) {
                this.closestWaystone = null;
            }
        }
    }

    @Override
    public boolean updateWaystoneTitle(Player player) {
        IWaystone _closestWaystone = this.closestWaystone;
        if (_closestWaystone == null || !_closestWaystone.hasName()) {
            return this.waystoneTitleRenderer.titleTimer > 0;
        }
        if (!(!this.waystoneTitleRenderer.enabled || this.waystoneTitleRenderer.cooldownTimer > 0 || this.waystoneTitleRenderer.matchesAnyRecentEntry(w -> w.getName().equals(_closestWaystone.getName())) || this.waystoneTitleRenderer.displayedTitle != null && _closestWaystone.getName().equals(this.waystoneTitleRenderer.displayedTitle.getString()))) {
            this.waystoneTitleRenderer.setColor(this.waystoneTitleRenderer.titleDefaultTextColor);
            this.waystoneTitleRenderer.displayTitle((Component)Component.m_237113_((String)_closestWaystone.getName()), null);
            this.waystoneTitleRenderer.cooldownTimer = TravelersTitlesCommon.CONFIG.waystones.textCooldownTime;
            this.waystoneTitleRenderer.addRecentEntry(_closestWaystone);
            if (TravelersTitlesCommon.titleManager.dimensionTitleRenderer.titleTimer <= 0) {
                player.m_5496_((SoundEvent)SoundModule.WAYSTONE.get(), (float)TravelersTitlesCommon.CONFIG.sound.waystoneVolume, (float)TravelersTitlesCommon.CONFIG.sound.waystonePitch);
            }
        }
        return this.waystoneTitleRenderer.titleTimer > 0;
    }

    @Override
    public void clientTick() {
        this.waystoneTitleRenderer.tick();
    }

    @Override
    public void renderText(float partialTicks, PoseStack matrixStack) {
        this.waystoneTitleRenderer.renderText(partialTicks, matrixStack);
    }

    @Override
    public void reset() {
        this.waystoneTitleRenderer.clearTimer();
        this.waystoneTitleRenderer.recentEntries.clear();
        this.waystoneTitleRenderer.displayedTitle = null;
    }

    @Override
    public boolean isRendering() {
        return this.waystoneTitleRenderer.titleTimer > 0;
    }

    @Override
    public void updateRendererFromConfig(ConfigModule.Waystones config) {
        this.waystoneTitleRenderer.maxRecentListSize = config.recentWaystoneCacheSize;
        this.waystoneTitleRenderer.enabled = config.enabled;
        this.waystoneTitleRenderer.titleFadeInTicks = config.textFadeInTime;
        this.waystoneTitleRenderer.titleDisplayTime = config.textDisplayTime;
        this.waystoneTitleRenderer.titleFadeOutTicks = config.textFadeOutTime;
        this.waystoneTitleRenderer.titleDefaultTextColor = config.textColor;
        this.waystoneTitleRenderer.showTextShadow = config.renderShadow;
        this.waystoneTitleRenderer.titleTextSize = (float)config.textSize;
        this.waystoneTitleRenderer.titleXOffset = (float)config.textXOffset;
        this.waystoneTitleRenderer.titleYOffset = (float)config.textYOffset;
        this.waystoneTitleRenderer.isTextCentered = config.centerText;
    }
}

