/*
 * Decompiled with CFR 0.152.
 */
package net.forsteri.createendertransmission.blocks.itemTransmitter;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;

public class ItemTransmitterInventoryHandler
extends CombinedInvWrapper {
    protected final Supplier<ItemStackHandler> superWrapper;

    public ItemTransmitterInventoryHandler(Supplier<ItemStackHandler> superWrapper) {
        super(new IItemHandlerModifiable[]{(IItemHandlerModifiable)superWrapper.get()});
        this.superWrapper = superWrapper;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.superWrapper.get().insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.superWrapper.get().extractItem(slot, amount, simulate);
    }

    public int getSlots() {
        return this.superWrapper.get().getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(index);
        slot = this.getSlotFromIndex(slot, index);
        return handler.getStackInSlot(slot);
    }

    protected IItemHandlerModifiable getHandlerFromIndex(int index) {
        if (index != 0) {
            return (IItemHandlerModifiable)EmptyHandler.INSTANCE;
        }
        return (IItemHandlerModifiable)this.superWrapper.get();
    }
}

