/*
 * Decompiled with CFR 0.152.
 */
package net.forsteri.createendertransmission.blocks.fluidTrasmitter;

import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.function.Supplier;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;

public class FluidTransmitterInventoryHandler
extends CombinedTankWrapper {
    protected final Supplier<IFluidHandler> superWrapper;

    public FluidTransmitterInventoryHandler(Supplier<IFluidHandler> handlers) {
        super(new IFluidHandler[]{handlers.get()});
        this.superWrapper = handlers;
    }

    protected IFluidHandler getHandlerFromIndex(int index) {
        if (index != 0) {
            return (IFluidHandler)EmptyHandler.INSTANCE;
        }
        return this.superWrapper.get();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return resource;
        }
        FluidStack drained = FluidStack.EMPTY;
        resource = resource.copy();
        IFluidHandler iFluidHandler = this.superWrapper.get();
        FluidStack drainedFromCurrent = iFluidHandler.drain(resource, action);
        int amount = drainedFromCurrent.getAmount();
        resource.shrink(amount);
        if (!drainedFromCurrent.isEmpty() && (drained.isEmpty() || drainedFromCurrent.isFluidEqual(drained))) {
            drained = new FluidStack(drainedFromCurrent.getFluid(), amount + drained.getAmount(), drainedFromCurrent.getTag());
        }
        return drained;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = FluidStack.EMPTY;
        IFluidHandler iFluidHandler = this.superWrapper.get();
        FluidStack drainedFromCurrent = iFluidHandler.drain(maxDrain, action);
        int amount = drainedFromCurrent.getAmount();
        if (!drainedFromCurrent.isEmpty() && (drained.isEmpty() || drainedFromCurrent.isFluidEqual(drained))) {
            drained = new FluidStack(drainedFromCurrent.getFluid(), amount + drained.getAmount(), drainedFromCurrent.getTag());
        }
        return drained;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        int filled = 0;
        resource = resource.copy();
        boolean fittingHandlerFound = false;
        for (boolean searchPass : Iterate.trueAndFalse) {
            IFluidHandler iFluidHandler = this.superWrapper.get();
            for (int i = 0; i < iFluidHandler.getTanks(); ++i) {
                if (!searchPass || !iFluidHandler.getFluidInTank(i).isFluidEqual(resource)) continue;
                fittingHandlerFound = true;
            }
            if (searchPass && !fittingHandlerFound) continue;
            int filledIntoCurrent = iFluidHandler.fill(resource, action);
            resource.shrink(filledIntoCurrent);
            filled += filledIntoCurrent;
            if (resource.isEmpty() || fittingHandlerFound && (this.enforceVariety || filledIntoCurrent != 0)) break;
        }
        return filled;
    }
}

