/*
 * Decompiled with CFR 0.152.
 */
package net.forsteri.createendertransmission.blocks.energyTransmitter;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.gui.ScreenOpener;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.forsteri.createendertransmission.blocks.energyTransmitter.EnergyTransmitterTileEntity;
import net.forsteri.createendertransmission.entry.Blocks;
import net.forsteri.createendertransmission.entry.TileEntities;
import net.forsteri.createendertransmission.transmitUtil.TransmitterScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class EnergyTransmitterBlock
extends DirectionalKineticBlock
implements IBE<EnergyTransmitterTileEntity>,
IWrenchable {
    public EnergyTransmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<EnergyTransmitterTileEntity> getBlockEntityClass() {
        return EnergyTransmitterTileEntity.class;
    }

    public BlockEntityType<? extends EnergyTransmitterTileEntity> getBlockEntityType() {
        return (BlockEntityType)TileEntities.ENERGY_TRANSMITTER_TILE.get();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockItem blockItem;
        ItemStack held = player.m_21205_();
        if (AllItems.WRENCH.isIn(held)) {
            return InteractionResult.PASS;
        }
        Item item = held.m_41720_();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof KineticBlock && this.hasShaftTowards((LevelReader)worldIn, pos, state, hit.m_82434_())) {
            return InteractionResult.PASS;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.withBlockEntityDo((BlockGetter)worldIn, pos, te -> this.displayScreen((EnergyTransmitterTileEntity)te, player)));
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(EnergyTransmitterTileEntity te, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new TransmitterScreen(te, Blocks.ENERGY_TRANSMITTER_BLOCK.asStack()));
        }
    }

    public void m_6810_(BlockState p_60515_, Level p_60516_, BlockPos p_60517_, BlockState p_60518_, boolean p_60519_) {
        if (this.getBlockEntity((BlockGetter)p_60516_, p_60517_) != null) {
            Objects.requireNonNull((EnergyTransmitterTileEntity)this.getBlockEntity((BlockGetter)p_60516_, p_60517_)).getConnectedTransmitters().remove(this.getBlockEntity((BlockGetter)p_60516_, p_60517_));
        }
        super.m_6810_(p_60515_, p_60516_, p_60517_, p_60518_, p_60519_);
    }
}

