/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CommandReward
extends Reward {
    public String command = "/say Hi, @p!";
    public boolean playerCommand;

    public CommandReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.COMMAND;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("command", this.command);
        nbt.m_128379_("player_command", this.playerCommand);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.command = nbt.m_128461_("command");
        this.playerCommand = nbt.m_128471_("player_command");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.command, Short.MAX_VALUE);
        buffer.writeBoolean(this.playerCommand);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.command = buffer.m_130136_(Short.MAX_VALUE);
        this.playerCommand = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("command", this.command, v -> {
            this.command = v;
        }, "/say Hi, @team!").setNameKey("ftbquests.reward.ftbquests.command");
        config.addBool("player", this.playerCommand, v -> {
            this.playerCommand = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        overrides.put("p", player.m_36316_().getName());
        BlockPos pos = player.m_20183_();
        overrides.put("x", pos.m_123341_());
        overrides.put("y", pos.m_123342_());
        overrides.put("z", pos.m_123343_());
        Chapter chapter = this.getQuestChapter();
        if (chapter != null) {
            overrides.put("chapter", chapter);
        }
        overrides.put("quest", this.quest);
        String s = this.command;
        for (Map.Entry entry : overrides.entrySet()) {
            if (entry.getValue() == null) continue;
            s = s.replace("@" + (String)entry.getKey(), entry.getValue().toString());
        }
        player.f_8924_.m_129892_().m_230957_(this.playerCommand ? player.m_20203_() : player.f_8924_.m_129893_(), s);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.reward.ftbquests.command").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)this.command).m_130940_(ChatFormatting.RED));
    }
}

