/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.loot;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.loot.EntityWeight;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class LootCrate {
    public static Map<String, LootCrate> LOOT_CRATES = new LinkedHashMap<String, LootCrate>();
    public final RewardTable table;
    public String stringID;
    public String itemName;
    public Color4I color;
    public boolean glow;
    public EntityWeight drops;

    public LootCrate(RewardTable t) {
        this.table = t;
        this.stringID = t.toString();
        this.itemName = "";
        this.color = Color4I.WHITE;
        this.glow = false;
        this.drops = new EntityWeight();
    }

    public void writeData(CompoundTag nbt) {
        nbt.m_128359_("string_id", this.stringID);
        if (!this.itemName.isEmpty()) {
            nbt.m_128359_("item_name", this.itemName);
        }
        nbt.m_128405_("color", this.color.rgb());
        if (this.glow) {
            nbt.m_128379_("glow", true);
        }
        CompoundTag nbt1 = new CompoundTag();
        this.drops.writeData(nbt1);
        nbt.m_128365_("drops", (Tag)nbt1);
    }

    public void readData(CompoundTag nbt) {
        this.stringID = nbt.m_128461_("string_id");
        this.itemName = nbt.m_128461_("item_name");
        this.color = Color4I.rgb((int)nbt.m_128451_("color"));
        this.glow = nbt.m_128471_("glow");
        this.drops.readData(nbt.m_128469_("drops"));
    }

    public void writeNetData(FriendlyByteBuf data) {
        data.m_130072_(this.stringID, Short.MAX_VALUE);
        data.m_130072_(this.itemName, Short.MAX_VALUE);
        data.writeInt(this.color.rgb());
        data.writeBoolean(this.glow);
        this.drops.writeNetData(data);
    }

    public void readNetData(FriendlyByteBuf data) {
        this.stringID = data.m_130136_(Short.MAX_VALUE);
        this.itemName = data.m_130136_(Short.MAX_VALUE);
        this.color = Color4I.rgb((int)data.readInt());
        this.glow = data.readBoolean();
        this.drops.readNetData(data);
    }

    public void getConfig(ConfigGroup config) {
        config.addString("id", this.stringID, v -> {
            this.stringID = v;
        }, "", Pattern.compile("[a-z0-9_]+"));
        config.addString("item_name", this.itemName, v -> {
            this.itemName = v;
        }, "");
        config.addString("color", this.color.toString(), v -> {
            this.color = Color4I.fromString((String)v);
        }, "#FFFFFF", Pattern.compile("^#[a-fA-F0-9]{6}$"));
        config.addBool("glow", this.glow, v -> {
            this.glow = v;
        }, true);
        ConfigGroup d = config.getGroup("drops");
        d.setNameKey("ftbquests.loot.entitydrops");
        d.addInt("passive", this.drops.passive, v -> {
            this.drops.passive = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.passive");
        d.addInt("monster", this.drops.monster, v -> {
            this.drops.monster = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.monster");
        d.addInt("boss", this.drops.boss, v -> {
            this.drops.boss = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.loot.entitytype.boss");
    }

    public String getStringID() {
        return this.stringID.isEmpty() ? QuestObjectBase.getCodeString(this.table) : this.stringID;
    }

    public ItemStack createStack() {
        ItemStack stack = new ItemStack((ItemLike)FTBQuestsItems.LOOTCRATE.get());
        stack.m_41700_("type", (Tag)StringTag.m_129297_((String)this.getStringID()));
        return stack;
    }
}

