/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.MoveMovableMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QuestLink
extends QuestObject
implements Movable {
    private Chapter chapter;
    private long linkId;
    private double x;
    private double y;
    private String shape;
    private double size;

    public QuestLink(Chapter chapter, long linkId) {
        this.chapter = chapter;
        this.linkId = linkId;
        this.shape = "";
        this.size = 1.0;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST_LINK;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public Component getAltTitle() {
        return this.getQuest().map(Quest::getAltTitle).orElse((Component)Component.m_237119_());
    }

    @Override
    public Icon getAltIcon() {
        return this.getQuest().map(Quest::getAltIcon).orElse(null);
    }

    @Override
    public int getRelativeProgressFromChildren(TeamData data) {
        return 0;
    }

    public Optional<Quest> getQuest() {
        Optional<Quest> optional;
        QuestObject questObject = this.chapter.file.get(this.linkId);
        if (questObject instanceof Quest) {
            Quest q = (Quest)questObject;
            optional = Optional.of(q);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public long getParentID() {
        return this.chapter.id;
    }

    @Override
    public void onCreated() {
        this.chapter.questLinks.add(this);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.questLinks.remove(this);
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("shape", (Object)(this.shape.isEmpty() ? "default" : this.shape), v -> {
            this.shape = v.equals("default") ? "" : v;
        }, QuestShape.idMapWithDefault);
        config.addDouble("size", this.size, v -> {
            this.size = v;
        }, 1.0, 0.0625, 8.0);
        config.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.questPanel.refreshWidgets();
            gui.viewQuestPanel.refreshWidgets();
        }
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("linked_quest", QuestLink.getCodeString(this.linkId));
        nbt.m_128347_("x", this.x);
        nbt.m_128347_("y", this.y);
        if (!this.shape.isEmpty()) {
            nbt.m_128359_("shape", this.shape);
        }
        if (this.size != 1.0) {
            nbt.m_128347_("size", this.size);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.linkId = Long.parseLong(nbt.m_128461_("linked_quest"), 16);
        this.x = nbt.m_128459_("x");
        this.y = nbt.m_128459_("y");
        this.shape = nbt.m_128461_("shape");
        if (this.shape.equals("default")) {
            this.shape = "";
        }
        this.size = nbt.m_128441_("size") ? nbt.m_128459_("size") : 1.0;
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeLong(this.linkId);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.size);
        buffer.m_130070_(this.shape);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.linkId = buffer.readLong();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.size = buffer.readDouble();
        this.shape = buffer.m_130136_(64);
    }

    public void setPosition(double qx, double qy) {
        this.x = qx;
        this.y = qy;
    }

    @Override
    public long getMovableID() {
        return this.id;
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.size;
    }

    @Override
    public double getHeight() {
        return this.size;
    }

    @Override
    public String getShape() {
        return this.shape.isEmpty() ? this.chapter.getDefaultQuestShape() : this.shape;
    }

    @Override
    public void move(Chapter to, double x, double y) {
        new MoveMovableMessage(this, to.id, x, y).sendToServer();
    }

    @Override
    public void onMoved(double x, double y, long chapterId) {
        QuestFile f;
        Chapter newChapter;
        this.x = x;
        this.y = y;
        if (chapterId != this.chapter.id && (newChapter = (f = this.getQuestFile()).getChapter(chapterId)) != null) {
            this.chapter.questLinks.remove(this);
            newChapter.questLinks.add(this);
            this.chapter = newChapter;
        }
    }

    public boolean linksTo(Quest quest) {
        return this.linkId == quest.id;
    }
}

