/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.jei;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStackToListCache<T> {
    private static final int MAX_CACHE_SIZE = 1024;
    private final Object2ObjectLinkedOpenCustomHashMap<ItemStack, List<T>> cacheMap = new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)new ItemStackHashingStrategy());

    public List<T> getList(ItemStack stack, Function<ItemStack, List<T>> toCompute) {
        if (this.cacheMap.containsKey((Object)stack)) {
            return (List)this.cacheMap.getAndMoveToFirst((Object)stack);
        }
        List<T> list = toCompute.apply(stack);
        if (this.cacheMap.size() == 1024) {
            this.cacheMap.removeLast();
        }
        this.cacheMap.put((Object)stack, list);
        return list;
    }

    public void clear() {
        this.cacheMap.clear();
    }

    private static class ItemStackHashingStrategy
    implements Hash.Strategy<ItemStack> {
        private ItemStackHashingStrategy() {
        }

        public int hashCode(ItemStack object) {
            int hashCode = Item.m_41393_((Item)object.m_41720_());
            if (object.m_41783_() != null) {
                hashCode += 37 * object.m_41783_().hashCode();
            }
            return hashCode;
        }

        public boolean equals(ItemStack o1, ItemStack o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.m_41720_() == o2.m_41720_() && (o1.m_41783_() == null || o1.m_41783_().equals((Object)o2.m_41783_()));
        }
    }
}

