/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.CompactGridLayout;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ValidItemsScreen
extends BaseScreen {
    public final ItemTask task;
    public final List<ItemStack> validItems;
    public String title = "";
    public final boolean canClick;
    public final Panel itemPanel;
    public final Button backButton;
    public final Button submitButton;

    public ValidItemsScreen(ItemTask t, List<ItemStack> v, boolean c) {
        this.task = t;
        this.validItems = v;
        this.canClick = c;
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (ItemStack validItem : ValidItemsScreen.this.validItems) {
                    this.add((Widget)new ValidItemButton(this, validItem));
                }
            }

            public void alignWidgets() {
                this.align((WidgetLayout)new CompactGridLayout(36));
                this.setHeight(Math.min(160, this.getContentHeight()));
                this.parent.setHeight(this.height + 53);
                int off = (this.width - this.getContentWidth()) / 2;
                for (Widget widget : this.widgets) {
                    widget.setX(widget.posX + off);
                }
                ValidItemsScreen.this.itemPanel.setX((this.parent.width - this.width) / 2);
                ValidItemsScreen.this.backButton.setPosAndSize(ValidItemsScreen.this.itemPanel.posX - 1, this.height + 28, 70, 20);
                ValidItemsScreen.this.submitButton.setPosAndSize(ValidItemsScreen.this.itemPanel.posX + 75, this.height + 28, 70, 20);
            }

            public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
                theme.drawButton(matrixStack, x - 1, y - 1, w + 2, h + 2, WidgetType.NORMAL);
            }
        };
        this.itemPanel.setPosAndSize(0, 22, 144, 0);
        this.backButton = new SimpleTextButton((Panel)this, (Component)Component.m_237115_((String)"gui.back"), (Icon)Color4I.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                ValidItemsScreen.this.onBack();
            }

            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.submitButton = new SimpleTextButton((Panel)this, (Component)Component.m_237113_((String)"Submit"), (Icon)Color4I.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                new SubmitTaskMessage(ValidItemsScreen.this.task.id).sendToServer();
                ValidItemsScreen.this.onBack();
            }

            public void addMouseOverText(TooltipList list) {
                if (ValidItemsScreen.this.canClick && !ValidItemsScreen.this.task.consumesResources() && !ValidItemsScreen.this.task.isTaskScreenOnly()) {
                    list.translate("ftbquests.task.auto_detected", new Object[0]);
                }
            }

            public WidgetType getWidgetType() {
                return ValidItemsScreen.this.canClick && ValidItemsScreen.this.task.consumesResources() && !ValidItemsScreen.this.task.isTaskScreenOnly() ? super.getWidgetType() : WidgetType.DISABLED;
            }

            public boolean renderTitleInCenter() {
                return true;
            }
        };
    }

    public void addWidgets() {
        this.title = Component.m_237110_((String)"ftbquests.task.ftbquests.item.valid_for", (Object[])new Object[]{this.task.getTitle()}).getString();
        this.setWidth(Math.max(156, this.getTheme().getStringWidth(this.title) + 12));
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.backButton);
        this.add((Widget)this.submitButton);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
        theme.drawString(matrixStack, (Object)this.title, (float)x + (float)w / 2.0f, (float)(y + 6), Color4I.WHITE, 4);
    }

    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if (key.esc()) {
            this.onBack();
            return true;
        }
        return false;
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.onBack();
        }
        return false;
    }

    public static class ValidItemButton
    extends Button {
        public final ItemStack stack;

        public ValidItemButton(Panel panel, ItemStack is) {
            super(panel, (Component)Component.m_237119_(), ItemIcon.getItemIcon((ItemStack)is));
            this.stack = is;
        }

        public void onClicked(MouseButton button) {
            if (FTBQuestsJEIHelper.isRecipeModAvailable()) {
                FTBQuestsJEIHelper.showRecipes(this.stack);
            }
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return new WrappedIngredient((Object)this.stack).tooltip();
        }

        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 10.0);
            matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
            GuiHelper.drawItem((PoseStack)matrixStack, (ItemStack)this.stack, (int)0, (boolean)true, null);
            matrixStack.m_85849_();
        }
    }
}

