/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.proxy.ClientUtils;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BlockEntityTomb
extends BlockEntity {
    private static final int SOULTIMER = 100;
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    protected String ownerName = "";
    protected long deathDate;
    public int timer = 0;
    protected UUID ownerId = null;
    private boolean onlyOwnersAccess = true;

    public BlockEntityTomb(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)TombRegistry.TOMBSTONE_BLOCK_ENTITY.get(), pos, blockState);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(120);
    }

    public void giveInventory(@Nullable Player player) {
        IItemHandler inventory = (IItemHandler)this.handler.orElse(null);
        if (!this.f_58857_.f_46443_ && player != null && !(player instanceof FakePlayer)) {
            for (int i = inventory.getSlots() - 1; i >= 0; --i) {
                if (!EntityHelper.autoEquip(inventory.getStackInSlot(i), player)) continue;
                inventory.extractItem(i, 64, false);
            }
            IntStream.range(0, inventory.getSlots()).forEach(ix -> {
                ItemStack stack = inventory.getStackInSlot(ix);
                if (!stack.m_41619_()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.m_41777_());
                    inventory.extractItem(ix, 64, false);
                }
            });
            this.removeGraveBy(player);
            if (player.f_36095_ != null) {
                player.f_36095_.m_38946_();
            }
            MessageType.MESSAGE_OPEN_GRAVE_SUCCESS.sendSpecialMessage(player, new Object[0]);
        }
    }

    public void dropInventory(Level level, BlockPos pos) {
        IItemHandler inventory = (IItemHandler)this.handler.orElse(null);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)inventory.extractItem(i, stack.m_41613_(), false));
            }
        }
    }

    public boolean onlyOwnersCanAccess() {
        return this.onlyOwnersAccess;
    }

    private void removeGraveBy(@Nullable Player player) {
        if (this.f_58857_ != null) {
            WorldHelper.removeNoEvent(this.f_58857_, this.f_58858_);
            if (player != null) {
                this.f_58857_.m_5594_(player, player.m_20183_(), SoundEvents.f_12626_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void initTombstoneOwner(Player owner) {
        this.deathDate = System.currentTimeMillis();
        this.ownerName = owner.m_5446_().getString();
        this.ownerId = owner.m_20148_();
    }

    public void initTombstoneOwner(GameProfile owner) {
        this.deathDate = 0L;
        this.ownerName = owner.getName();
        this.ownerId = owner.getId();
    }

    public boolean isOwner(Player owner) {
        if (this.ownerId == null || owner == null || !this.hasOwner()) {
            return false;
        }
        return this.ownerId.equals(owner.m_20148_());
    }

    public AABB getRenderBoundingBox() {
        double renderExtension = 1.0;
        return new AABB((double)this.f_58858_.m_123341_() - renderExtension, (double)this.f_58858_.m_123342_() - renderExtension, (double)this.f_58858_.m_123343_() - renderExtension, (double)(this.f_58858_.m_123341_() + 1) + renderExtension, (double)(this.f_58858_.m_123342_() + 1) + renderExtension, (double)(this.f_58858_.m_123343_() + 1) + renderExtension);
    }

    String getOwnerName() {
        return this.ownerName;
    }

    boolean hasOwner() {
        return this.ownerName != null && this.ownerName.length() > 0;
    }

    long getOwnerDeathTime() {
        return this.deathDate;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("ownerName", this.ownerName);
        compound.m_128356_("deathDate", this.deathDate);
        compound.m_128405_("countTicks", this.timer);
        if (this.ownerId != null) {
            compound.m_128362_("ownerid", this.ownerId);
        }
        this.handler.ifPresent(h -> {
            CompoundTag ct = (CompoundTag)((INBTSerializable)h).serializeNBT();
            compound.m_128365_("inv", (Tag)ct);
        });
        compound.m_128379_("onlyOwnersAccess", this.onlyOwnersAccess);
    }

    public void m_142466_(CompoundTag compound) {
        this.ownerName = compound.m_128461_("ownerName");
        this.deathDate = compound.m_128454_("deathDate");
        this.timer = compound.m_128451_("countTicks");
        CompoundTag invTag = compound.m_128469_("inv");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)invTag));
        if (compound.m_128403_("ownerid")) {
            this.ownerId = compound.m_128342_("ownerid");
        }
        this.onlyOwnersAccess = compound.m_128471_("onlyOwnersAccess");
        super.m_142466_(compound);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.handler.invalidate();
        super.invalidateCaps();
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        super.m_183515_(compound);
        compound.m_128359_("ownerName", this.ownerName);
        compound.m_128356_("deathDate", this.deathDate);
        compound.m_128405_("countTicks", this.timer);
        return compound;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean m_7531_(int id, int type) {
        return true;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, BlockEntityTomb tile) {
        ClientUtils.produceGraveSmoke(level, tile.f_58858_.m_123341_(), tile.f_58858_.m_123342_(), tile.f_58858_.m_123343_());
        ++tile.timer;
        if (tile.timer % 100 == 0) {
            ClientUtils.produceGraveSoul(level, tile.f_58858_);
            tile.timer = 1;
        }
        if (level.f_46443_) {
            ClientUtils.produceGraveSmoke(level, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        }
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, BlockEntityTomb tile) {
        ++tile.timer;
        if ((tile.timer - 1) % 100 == 0) {
            tile.timer = 1;
        }
    }
}

