/*
 * Decompiled with CFR 0.152.
 */
package shadows.fastsuite;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.fastsuite.AuxRecipeManager;
import shadows.fastsuite.StreamUtils;
import shadows.placebo.config.Configuration;

@Mod(value="fastsuite")
public class FastSuite {
    public static final String MODID = "fastsuite";
    public static final Logger LOGGER = LogManager.getLogger((String)"fastsuite");
    public static boolean DEBUG = false;
    public static final int MIN_SIZE_REQUIRED_FOR_THREADING = 100;
    public static int maxRecipeLookupTime = 25;
    public static Set<RecipeType<?>> singleThreadedLookups = new HashSet();

    public FastSuite() {
        StreamUtils.setup(this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        if (DEBUG) {
            MinecraftForge.EVENT_BUS.addListener(this::test);
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        String[] stLookups;
        Configuration cfg = new Configuration(MODID);
        cfg.setTitle("FastSuite Configuration");
        for (String s : stLookups = cfg.getStringList("Single Threaded Recipe Types", "general", new String[0], "A list of recipe types which may only be looked up on the main thread. Add a recipe type to this list if errors start happening.")) {
            try {
                singleThreadedLookups.add((RecipeType)ForgeRegistries.RECIPE_TYPES.getValue(new ResourceLocation(s)));
            }
            catch (Exception ex) {
                LOGGER.error("Invalid single threaded recipe type name {} will be ignored.", (Object)s);
            }
        }
        maxRecipeLookupTime = cfg.getInt("Max Recipe Lookup Time", "general", maxRecipeLookupTime, 1, 300, "The max time, in seconds, that a recipe lookup may take before aborting the lookup and logging an error.");
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    public void test(ServerStartedEvent e) {
        LOGGER.info("FastSuite Debug Recipe Counts:");
        for (RecipeType type : ForgeRegistries.RECIPE_TYPES.getValues()) {
            LOGGER.info("{}: {}", (Object)ForgeRegistries.RECIPE_TYPES.getKey((Object)type), (Object)e.getServer().m_129894_().m_44013_(type).size());
        }
        LOGGER.info("Initiating FastSuite Tests...");
        AuxRecipeManager mgr = (AuxRecipeManager)e.getServer().m_129894_();
        CraftingContainer inv = new CraftingContainer((AbstractContainerMenu)new TestMenu(), 2, 2);
        ServerLevel world = e.getServer().m_129880_(Level.f_46428_);
        inv.m_6836_(0, new ItemStack((ItemLike)Items.f_41841_));
        CraftingContainer inv2 = new CraftingContainer((AbstractContainerMenu)new TestMenu(), 2, 2);
        inv2.m_6836_(0, new ItemStack((ItemLike)Items.f_42753_));
        inv2.m_6836_(2, new ItemStack((ItemLike)Items.f_42753_));
        CraftingContainer inv3 = new CraftingContainer((AbstractContainerMenu)new TestMenu(), 2, 2);
        for (int i = 0; i < 4; ++i) {
            inv3.m_6836_(i, new ItemStack((ItemLike)Items.f_42647_));
        }
        CraftingContainer inv4 = new CraftingContainer((AbstractContainerMenu)new TestMenu(), 2, 2);
        inv4.m_6836_(0, new ItemStack((ItemLike)Items.f_42265_));
        inv4.m_6836_(3, new ItemStack((ItemLike)Items.f_42498_));
        CraftingContainer inv5 = new CraftingContainer((AbstractContainerMenu)new TestMenu(), 3, 3);
        inv5.m_6836_(0, new ItemStack((ItemLike)Items.f_42398_));
        inv5.m_6836_(1, new ItemStack((ItemLike)Items.f_41862_));
        inv5.m_6836_(2, new ItemStack((ItemLike)Items.f_42042_));
        inv5.m_6836_(3, new ItemStack((ItemLike)Items.f_41900_));
        inv5.m_6836_(4, new ItemStack((ItemLike)Items.f_42410_));
        inv5.m_6836_(5, new ItemStack((ItemLike)Items.f_42786_));
        inv5.m_6836_(6, new ItemStack((ItemLike)Items.f_42785_));
        inv5.m_6836_(7, new ItemStack((ItemLike)Items.f_42498_));
        inv5.m_6836_(8, new ItemStack((ItemLike)Items.f_42265_));
        CraftingContainer[] arr = new CraftingContainer[]{inv, inv2, inv3, inv4, inv5};
        String[] names = new String[]{"acacia planks", "sticks", "crafting table", "black shulker box", "failed match"};
        for (int testCase = 0; testCase < names.length; ++testCase) {
            this.testMulti(mgr, (Level)world, arr[testCase], names[testCase]);
            this.testSingle(mgr, (Level)world, arr[testCase], names[testCase]);
        }
    }

    private void testMulti(AuxRecipeManager mgr, Level level, CraftingContainer input, String recipeName) {
        long deltaSum = 0L;
        int iterations = 10000;
        for (int i = 0; i < iterations; ++i) {
            long time = System.nanoTime();
            mgr.m_44015_(RecipeType.f_44107_, input, level);
            long time2 = System.nanoTime();
            deltaSum += time2 - time;
        }
        LOGGER.info("[Multithreaded Test] - Took an average of {} ns to find the recipe for {}", (Object)Float.valueOf((float)deltaSum / (float)iterations), (Object)recipeName);
    }

    private void testSingle(AuxRecipeManager mgr, Level level, CraftingContainer input, String recipeName) {
        long deltaSum = 0L;
        int iterations = 10000;
        for (int i = 0; i < iterations; ++i) {
            long time = System.nanoTime();
            mgr.super_getRecipeFor(RecipeType.f_44107_, input, level);
            long time2 = System.nanoTime();
            deltaSum += time2 - time;
        }
        LOGGER.info("[Singlethreaded Test] - Took an average of {} ns to find the recipe for {}", (Object)Float.valueOf((float)deltaSum / (float)iterations), (Object)recipeName);
    }

    private static class TestMenu
    extends AbstractContainerMenu {
        protected TestMenu() {
            super(null, -1);
        }

        public ItemStack m_7648_(Player pPlayer, int pIndex) {
            return ItemStack.f_41583_;
        }

        public boolean m_6875_(Player pPlayer) {
            return true;
        }
    }
}

