/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.InventoryCraftingDecompress;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class CompressMessage {
    private final int slotNumber;
    private final CompressType type;

    public CompressMessage(int slotNumber, CompressType type) {
        this.slotNumber = slotNumber;
        this.type = type;
    }

    public static CompressMessage decode(FriendlyByteBuf buf) {
        int slotNumber = buf.readInt();
        CompressType type = CompressType.values()[buf.readByte()];
        return new CompressMessage(slotNumber, type);
    }

    public static void encode(CompressMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.slotNumber);
        buf.writeByte(message.type.ordinal());
    }

    public static void handle(ServerPlayer player, CompressMessage message) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.f_36096_;
        if (menu == null) {
            return;
        }
        CompressType compressType = message.type;
        Slot mouseSlot = (Slot)menu.f_38839_.get(message.slotNumber);
        if (!(mouseSlot.f_40218_ instanceof Inventory)) {
            return;
        }
        ItemStack mouseStack = mouseSlot.m_7993_();
        if (mouseStack.m_41619_()) {
            return;
        }
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        boolean compressAnywhere = CraftingTweaksConfig.getActive().common.compressAnywhere;
        if (!compressAnywhere && grid == null) {
            return;
        }
        if (compressType == CompressType.DECOMPRESS_ALL || compressType == CompressType.DECOMPRESS_STACK || compressType == CompressType.DECOMPRESS_ONE) {
            boolean decompressAll = compressType != CompressType.DECOMPRESS_ONE;
            block5: for (Slot slot : menu.f_38839_) {
                ItemStack result;
                if (compressType != CompressType.DECOMPRESS_ALL && slot != mouseSlot) continue;
                ItemStack slotStack = slot.m_7993_();
                if (!(slot.f_40218_ instanceof Inventory) || !ItemStack.m_150942_((ItemStack)slot.m_7993_(), (ItemStack)mouseSlot.m_7993_()) || (result = CompressMessage.findMatchingResult(new InventoryCraftingDecompress(menu, slotStack), player)).m_41619_() || CompressMessage.isBlacklisted(result) || slotStack.m_41619_() || slotStack.m_41613_() < 1) continue;
                while (player.m_150109_().m_36054_(result.m_41777_())) {
                    CompressMessage.giveLeftoverItems(player, slotStack, 1);
                    slot.m_6201_(1);
                    if (decompressAll && slot.m_6657_() && slotStack.m_41613_() >= 1 && slotStack.m_41720_() != result.m_41720_()) continue;
                    continue block5;
                }
            }
        } else {
            switch (compressType) {
                case COMPRESS_ONE: {
                    CompressMessage.compressMouseSlot(player, menu, mouseSlot, grid, compressAnywhere, false);
                    break;
                }
                case COMPRESS_STACK: {
                    CompressMessage.compressMouseSlot(player, menu, mouseSlot, grid, compressAnywhere, true);
                    break;
                }
                case COMPRESS_ALL: {
                    CompressMessage.compressAll(player, menu, mouseSlot, grid, compressAnywhere);
                }
            }
        }
        menu.m_38946_();
    }

    private static void compressMouseSlot(ServerPlayer player, AbstractContainerMenu menu, Slot mouseSlot, CraftingGrid grid, boolean compressAnywhere, boolean wholeStack) {
        int maxGridSize = grid != null && !compressAnywhere ? grid.getGridSize((Player)player, menu) : 9;
        ItemStack mouseStack = mouseSlot.m_7993_();
        CompressionRecipe recipe = CompressMessage.findRecipe(menu, player, mouseStack, maxGridSize);
        int recipeSize = recipe.size();
        if (recipeSize > 0) {
            int craftsPossible = wholeStack ? mouseStack.m_41613_() / recipeSize : 1;
            int itemsToRemove = craftsPossible * recipeSize;
            mouseStack.m_41774_(itemsToRemove);
            CompressMessage.addCraftedItemsToInventory((Player)player, recipe.result(), craftsPossible);
        }
    }

    private static void compressAll(ServerPlayer player, AbstractContainerMenu menu, Slot mouseSlot, CraftingGrid grid, boolean compressAnywhere) {
        int maxGridSize = grid != null && !compressAnywhere ? grid.getGridSize((Player)player, menu) : 9;
        ItemStack mouseStack = mouseSlot.m_7993_().m_41777_();
        int totalItemCount = CompressMessage.countTotalItems(menu, mouseStack);
        CompressionRecipe recipe = CompressMessage.findRecipe(menu, player, mouseStack, maxGridSize);
        int recipeSize = recipe.size();
        if (recipeSize > 0) {
            int craftsPossible = totalItemCount / recipeSize;
            int itemsToRemove = craftsPossible * recipeSize;
            CompressMessage.removeSourceItems(menu, mouseStack, itemsToRemove);
            CompressMessage.addCraftedItemsToInventory((Player)player, recipe.result(), craftsPossible);
        }
    }

    private static void giveLeftoverItems(ServerPlayer player, ItemStack slotStack, int count) {
        for (int i = 0; i < count; ++i) {
            ItemEntity itemEntity;
            ItemStack containerItem = Balm.getHooks().getCraftingRemainingItem(slotStack);
            if (player.m_36356_(containerItem) || (itemEntity = player.m_36176_(containerItem, false)) == null) continue;
            itemEntity.m_32061_();
            itemEntity.m_32047_(player.m_20148_());
        }
    }

    private static <T extends CraftingContainer> ItemStack findMatchingResult(T craftingInventory, ServerPlayer player) {
        RecipeManager recipeManager = Objects.requireNonNull(player.m_20194_()).m_129894_();
        CraftingRecipe recipe = recipeManager.m_44015_(RecipeType.f_44107_, craftingInventory, player.f_19853_).orElse(null);
        if (recipe != null && ((RecipeHolder)craftingInventory).m_40135_(player.f_19853_, player, (Recipe)recipe)) {
            return recipe.m_5874_(craftingInventory);
        }
        return ItemStack.f_41583_;
    }

    private static boolean isBlacklisted(ItemStack result) {
        ResourceLocation registryName = Registry.f_122827_.m_7981_((Object)result.m_41720_());
        return CraftingTweaksConfig.getActive().common.compressBlacklist.contains(registryName.toString());
    }

    private static int countTotalItems(AbstractContainerMenu menu, ItemStack sourceItem) {
        int totalItemCount = 0;
        for (Slot slot : menu.f_38839_) {
            ItemStack slotStack = slot.m_7993_();
            if (!(slot.f_40218_ instanceof Inventory) || !ItemStack.m_150942_((ItemStack)slot.m_7993_(), (ItemStack)sourceItem)) continue;
            totalItemCount += slotStack.m_41613_();
        }
        return totalItemCount;
    }

    private static CompressionRecipe findRecipe(AbstractContainerMenu menu, ServerPlayer player, ItemStack exampleStack, int maxGridSize) {
        InventoryCraftingCompress exampleInventory;
        int recipeSize = 0;
        ItemStack result = ItemStack.f_41583_;
        if (maxGridSize >= 9 && !(result = CompressMessage.findMatchingResult(exampleInventory = new InventoryCraftingCompress(menu, 3, exampleStack), player)).m_41619_() && !CompressMessage.isBlacklisted(result)) {
            recipeSize = 9;
        }
        if (recipeSize == 0 && maxGridSize >= 4 && !(result = CompressMessage.findMatchingResult(exampleInventory = new InventoryCraftingCompress(menu, 2, exampleStack), player)).m_41619_() && !CompressMessage.isBlacklisted(result)) {
            recipeSize = 4;
        }
        return new CompressionRecipe(recipeSize, result);
    }

    private static void removeSourceItems(AbstractContainerMenu menu, ItemStack sourceItem, int itemsToRemove) {
        for (Slot slot : menu.f_38839_) {
            ItemStack slotStack = slot.m_7993_();
            if (!(slot.f_40218_ instanceof Inventory) || !ItemStack.m_150942_((ItemStack)slot.m_7993_(), (ItemStack)sourceItem)) continue;
            int removedFromSlot = Math.min(slotStack.m_41613_(), itemsToRemove);
            slot.m_6201_(removedFromSlot);
            if ((itemsToRemove -= removedFromSlot) != 0) continue;
            break;
        }
    }

    private static void addCraftedItemsToInventory(Player player, ItemStack result, int timesCrafted) {
        ItemStack craftedStack;
        for (int itemsCrafted = timesCrafted * result.m_41613_(); itemsCrafted > 0; itemsCrafted -= craftedStack.m_41613_()) {
            craftedStack = result.m_41777_();
            craftedStack.m_41764_(Math.min(itemsCrafted, result.m_41741_()));
            if (player.m_150109_().m_36054_(craftedStack)) continue;
            player.m_36176_(craftedStack, true);
        }
    }

    record CompressionRecipe(int size, ItemStack result) {
    }
}

