/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.network;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.core.DistTypeConverter;
import fuzs.puzzleslib.network.Message;
import fuzs.puzzleslib.network.MessageDirection;
import fuzs.puzzleslib.network.NetworkHandler;
import fuzs.puzzleslib.proxy.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeNetworkHandler
implements NetworkHandler {
    private static final Map<String, ForgeNetworkHandler> MOD_TO_NETWORK = Maps.newConcurrentMap();
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private final SimpleChannel channel;
    private final boolean clientAcceptsVanillaOrMissing;
    private final boolean serverAcceptsVanillaOrMissing;
    private final AtomicInteger discriminator = new AtomicInteger();

    private ForgeNetworkHandler(SimpleChannel channel, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        this.channel = channel;
        this.clientAcceptsVanillaOrMissing = clientAcceptsVanillaOrMissing;
        this.serverAcceptsVanillaOrMissing = serverAcceptsVanillaOrMissing;
    }

    @Override
    public <T extends Message<T>> void register(Class<? extends T> clazz, Supplier<T> factory, MessageDirection direction) {
        BiConsumer<Message, FriendlyByteBuf> encode = Message::write;
        Function<FriendlyByteBuf, Message> decode = buf -> {
            Message message = (Message)factory.get();
            message.read((FriendlyByteBuf)buf);
            return message;
        };
        BiConsumer<Message, Supplier> handle = (message, supplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            LogicalSide receptionSide = DistTypeConverter.toLogicalSide(direction.getReceptionSide());
            LogicalSide expectedReceptionSide = context.getDirection().getReceptionSide();
            if (expectedReceptionSide != receptionSide) {
                throw new IllegalStateException(String.format("Received message on wrong side, expected %s, was %s", receptionSide, expectedReceptionSide));
            }
            context.enqueueWork(() -> {
                Object player = receptionSide.isClient() ? Proxy.INSTANCE.getClientPlayer() : context.getSender();
                message.makeHandler().handle((Message)message, (Player)player, LogicalSidedProvider.WORKQUEUE.get(receptionSide));
            });
            context.setPacketHandled(true);
        };
        this.channel.registerMessage(this.discriminator.getAndIncrement(), clazz, encode, decode, handle);
    }

    @Override
    public Packet<?> toServerboundPacket(Message<?> message) {
        return this.channel.toVanillaPacket(message, NetworkDirection.PLAY_TO_SERVER);
    }

    @Override
    public Packet<?> toClientboundPacket(Message<?> message) {
        return this.channel.toVanillaPacket(message, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static synchronized NetworkHandler of(String modId, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        ForgeNetworkHandler handler = MOD_TO_NETWORK.computeIfAbsent(modId, modId1 -> new ForgeNetworkHandler(ForgeNetworkHandler.buildSimpleChannel(modId1, clientAcceptsVanillaOrMissing, serverAcceptsVanillaOrMissing), clientAcceptsVanillaOrMissing, serverAcceptsVanillaOrMissing));
        if (handler.clientAcceptsVanillaOrMissing != clientAcceptsVanillaOrMissing) {
            throw new IllegalArgumentException("client channel settings mismatch, expected %s, but was %s".formatted(handler.clientAcceptsVanillaOrMissing, clientAcceptsVanillaOrMissing));
        }
        if (handler.serverAcceptsVanillaOrMissing != serverAcceptsVanillaOrMissing) {
            throw new IllegalArgumentException("server channel settings mismatch, expected %s, but was %s".formatted(handler.serverAcceptsVanillaOrMissing, serverAcceptsVanillaOrMissing));
        }
        return handler;
    }

    private static SimpleChannel buildSimpleChannel(String modId, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modId, "play")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions((Predicate)(clientAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).serverAcceptedVersions((Predicate)(serverAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).simpleChannel();
    }
}

