/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.core.ContentRegistrationFlags;
import fuzs.puzzleslib.core.ModConstructor;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.biome.BiomeLoadingHandler;
import fuzs.puzzleslib.mixin.accessor.FireBlockForgeAccessor;
import fuzs.puzzleslib.util.PuzzlesUtilForge;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.util.Strings;

public class ForgeModConstructor {
    private final ModConstructor constructor;
    private final Object2IntOpenHashMap<Item> fuelBurnTimes = new Object2IntOpenHashMap();
    private final Multimap<BiomeLoadingPhase, BiomeLoadingHandler.BiomeModificationData> biomeLoadingEntries = HashMultimap.create();

    private ForgeModConstructor(ModConstructor constructor) {
        this.constructor = constructor;
        constructor.onConstructMod();
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent evt) {
        this.constructor.onCommonSetup(arg_0 -> ((FMLCommonSetupEvent)evt).enqueueWork(arg_0));
        this.constructor.onRegisterFuelBurnTimes((burnTime, items) -> {
            if (Mth.m_14045_((int)burnTime, (int)1, (int)Short.MAX_VALUE) != burnTime) {
                throw new IllegalArgumentException("fuel burn time is out of bounds");
            }
            Objects.requireNonNull(items, "items is null");
            for (ItemLike item : items) {
                Objects.requireNonNull(item, "item is null");
                this.fuelBurnTimes.put((Object)item.m_5456_(), burnTime);
            }
        });
        this.constructor.onRegisterBiomeModifications((phase, selector, modifier) -> this.biomeLoadingEntries.put((Object)phase, (Object)new BiomeLoadingHandler.BiomeModificationData(phase, selector, modifier)));
        this.constructor.onRegisterFlammableBlocks((encouragement, flammability, blocks) -> {
            Objects.requireNonNull(blocks, "blocks is null");
            for (Block block : blocks) {
                Objects.requireNonNull(block, "block is null");
                ((FireBlockForgeAccessor)Blocks.f_50083_).puzzleslib$setFlammable(block, encouragement, flammability);
            }
        });
    }

    @SubscribeEvent
    public void onRegisterSpawnPlacement(final SpawnPlacementRegisterEvent evt) {
        this.constructor.onRegisterSpawnPlacements(new ModConstructor.SpawnPlacementsContext(){

            @Override
            public <T extends Mob> void registerSpawnPlacement(EntityType<T> entityType, SpawnPlacements.Type location, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
                evt.register(entityType, location, heightmap, spawnPredicate, SpawnPlacementRegisterEvent.Operation.REPLACE);
            }
        });
    }

    @SubscribeEvent
    public void onEntityAttributeCreation(EntityAttributeCreationEvent evt) {
        this.constructor.onEntityAttributeCreation((EntityType<? extends LivingEntity> entity, AttributeSupplier.Builder builder) -> evt.put(entity, builder.m_22265_()));
    }

    @SubscribeEvent
    public void onEntityAttributeModification(EntityAttributeModificationEvent evt) {
        this.constructor.onEntityAttributeModification((arg_0, arg_1, arg_2) -> ((EntityAttributeModificationEvent)evt).add(arg_0, arg_1, arg_2));
    }

    private ModConstructor.LootTablesReplaceContext getLootTablesReplaceContext(LootTables lootManager, ResourceLocation id, LootTable lootTable, final Consumer<LootTable> lootTableSetter) {
        return new ModConstructor.LootTablesReplaceContext(lootManager, id, lootTable){

            @Override
            public void setLootTable(LootTable table) {
                lootTableSetter.accept(table);
            }
        };
    }

    private ModConstructor.LootTablesModifyContext getLootTablesModifyContext(LootTables lootManager, ResourceLocation id, final LootTable lootTable) {
        return new ModConstructor.LootTablesModifyContext(lootManager, id){

            @Override
            public void addLootPool(LootPool pool) {
                lootTable.addPool(pool);
            }

            @Override
            public boolean removeLootPool(int index) {
                if (index == 0 && lootTable.removePool("main") != null) {
                    return true;
                }
                return lootTable.removePool("pool" + index) != null;
            }
        };
    }

    public static void construct(ModConstructor constructor, String modId, ContentRegistrationFlags ... contentRegistrations) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("mod id cannot be empty");
        }
        PuzzlesLib.LOGGER.info("Constructing common components for mod {}", (Object)modId);
        ForgeModConstructor forgeModConstructor = new ForgeModConstructor(constructor);
        IEventBus modEventBus = PuzzlesUtilForge.findModEventBus(modId);
        modEventBus.register((Object)forgeModConstructor);
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            Item item = evt.getItemStack().m_41720_();
            if (forgeModConstructor.fuelBurnTimes.containsKey((Object)item)) {
                evt.setBurnTime(forgeModConstructor.fuelBurnTimes.getInt((Object)item));
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> constructor.onRegisterCommands(new ModConstructor.RegisterCommandsContext((CommandDispatcher<CommandSourceStack>)evt.getDispatcher(), evt.getBuildContext(), evt.getCommandSelection())));
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            constructor.onLootTableReplacement(forgeModConstructor.getLootTablesReplaceContext(evt.getLootTableManager(), evt.getName(), evt.getTable(), arg_0 -> ((LootTableLoadEvent)evt).setTable(arg_0)));
            constructor.onLootTableModification(forgeModConstructor.getLootTablesModifyContext(evt.getLootTableManager(), evt.getName(), evt.getTable()));
        });
        if (ArrayUtils.contains((Object[])contentRegistrations, (Object)((Object)ContentRegistrationFlags.BIOMES))) {
            BiomeLoadingHandler.register(modId, modEventBus, forgeModConstructor.biomeLoadingEntries);
        }
    }
}

