/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.endertrigon.mixin;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.endertrigon.EnderTrigonMod;
import nonamecrackers2.endertrigon.common.entity.BabyEnderDragon;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.EnderDragonHead;
import nonamecrackers2.endertrigon.common.util.EnderDragonExtension;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnderDragon.class})
public abstract class MixinEnderDragon
extends Mob
implements EnderDragonExtension,
Enemy {
    private static final Predicate<Entity> NON_KNOCKBACKABLE = entity -> entity instanceof BabyEnderDragon;
    private EnderDragonHead[] otherHeads;

    private MixinEnderDragon(EntityType<? extends Mob> type, Level level) {
        super(type, level);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void constructorTail(EntityType<? extends EnderDragon> type, Level level, CallbackInfo ci) {
        EnderDragonPart head1 = new EnderDragonPart(this.getSelf(), "head1", 1.0f, 1.0f);
        EnderDragonPart neck1 = new EnderDragonPart(this.getSelf(), "neck1", 3.0f, 3.0f);
        EnderDragonPart head2 = new EnderDragonPart(this.getSelf(), "head2", 1.0f, 1.0f);
        EnderDragonPart neck2 = new EnderDragonPart(this.getSelf(), "neck2", 3.0f, 3.0f);
        this.otherHeads = new EnderDragonHead[]{new EnderDragonHead(this.getSelf(), head1, neck1, -30.0f, 5.0f, -18.0f, -0.5f, 1), new EnderDragonHead(this.getSelf(), head2, neck2, 30.0f, 5.0f, 18.0f, -0.5f, 2)};
        Object[] entities = new EnderDragonPart[]{head1, neck1, head2, neck2};
        this.getSelf().f_31089_ = (EnderDragonPart[])ArrayUtils.addAll((Object[])this.getSelf().f_31089_, (Object[])entities);
    }

    @Overwrite
    private void m_31141_(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || NON_KNOCKBACKABLE.test(entity) || this.getSelf().m_20197_().contains(entity)) continue;
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 10.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    @Overwrite
    private void m_31131_(List<Entity> entities) {
        EnderDragon self = this.getSelf();
        double d0 = (this.getBody().m_20191_().f_82288_ + this.getBody().m_20191_().f_82291_) / 2.0;
        double d1 = (this.getBody().m_20191_().f_82290_ + this.getBody().m_20191_().f_82293_) / 2.0;
        for (Entity entity : entities) {
            if (NON_KNOCKBACKABLE.test(entity) || !(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
            if (self.m_31157_().m_31415_().m_7080_() || living.m_21213_() >= entity.f_19797_ - 2) continue;
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 5.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    public void m_7332_(Entity entity) {
        super.m_7332_(entity);
        EnderDragonHead head = this.getOtherHeads()[1];
        if ((double)entity.m_20270_((Entity)head.head) < 20.0) {
            entity.m_6034_(head.head.m_20185_(), head.head.m_20186_(), head.head.m_20189_());
        }
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        EnderDragonHead head = this.getOtherHeads()[1];
        if ((double)passenger.m_20270_((Entity)head.head) < 20.0) {
            return head.head.m_20182_();
        }
        return super.m_7688_(passenger);
    }

    public boolean m_6128_() {
        return this.getSelf().m_31157_().m_31415_().m_7309_() == EnderTrigonMod.CRASH_PLAYER;
    }

    @Inject(method={"aiStep"}, at={@At(value="TAIL")})
    public void aiStepTail(CallbackInfo ci) {
        for (EnderDragonHead head : this.otherHeads) {
            head.tick();
        }
    }

    @Accessor
    public abstract EnderDragonPart getBody();

    @Override
    public EnderDragonHead[] getOtherHeads() {
        return this.otherHeads;
    }

    private EnderDragon getSelf() {
        return (EnderDragon)this;
    }
}

