/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase;

import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonSittingPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import nonamecrackers2.endertrigon.EnderTrigonMod;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase.DragonCrashPlayerPhase;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase.DragonDiveBombPlayerPhase;
import nonamecrackers2.endertrigon.common.entity.boss.enderdragon.phase.DragonSnatchPlayerPhase;
import org.apache.commons.lang3.ArrayUtils;

public class DragonChargeUpPhase
extends AbstractDragonSittingPhase {
    private static final int CHARGE_UP_TIME = 50;
    private static final TargetingConditions CHARGE_TARGETING = TargetingConditions.m_148352_();
    private int chargeUpTicks;
    private AttackType previousAttack = AttackType.CRASH_PLAYER;

    public DragonChargeUpPhase(EnderDragon dragon) {
        super(dragon);
    }

    public void m_6991_() {
        this.f_31176_.f_19853_.m_7785_(this.f_31176_.m_20185_(), this.f_31176_.m_20186_(), this.f_31176_.m_20189_(), SoundEvents.f_11894_, this.f_31176_.m_5720_(), 10.0f, 0.8f + this.f_31176_.m_217043_().m_188501_() * 0.3f, false);
    }

    public void m_6989_() {
        BlockPos pos = this.f_31176_.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos((Vec3i)EndPodiumFeature.f_65714_));
        Player player = this.f_31176_.f_19853_.m_45949_(CHARGE_TARGETING, (LivingEntity)this.f_31176_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        ++this.chargeUpTicks;
        if (this.chargeUpTicks > 50) {
            if (player != null) {
                AttackType type = AttackType.random(this.f_31176_.m_217043_(), this.previousAttack);
                type.activate(this.f_31176_.m_31157_(), (LivingEntity)player);
                this.previousAttack = type;
            } else {
                this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31377_);
            }
        } else if (player != null) {
            double x = player.m_20185_() - this.f_31176_.m_20185_();
            double z = player.m_20189_() - this.f_31176_.m_20189_();
            float yRot = (float)(Mth.m_14136_((double)z, (double)x) * 57.2957763671875) + 90.0f;
            this.f_31176_.m_146922_(yRot);
        }
    }

    public void m_7083_() {
        this.chargeUpTicks = 0;
    }

    public EnderDragonPhase<DragonChargeUpPhase> m_7309_() {
        return EnderTrigonMod.CHARGE_UP;
    }

    public static enum AttackType {
        SNATCH_PLAYER((manager, entity) -> {
            manager.m_31416_(EnderTrigonMod.SNATCH_PLAYER);
            ((DragonSnatchPlayerPhase)manager.m_31418_(EnderTrigonMod.SNATCH_PLAYER)).setTarget((LivingEntity)entity);
        }),
        CRASH_PLAYER((manager, entity) -> {
            manager.m_31416_(EnderTrigonMod.CRASH_PLAYER);
            ((DragonCrashPlayerPhase)manager.m_31418_(EnderTrigonMod.CRASH_PLAYER)).setTarget((LivingEntity)entity);
        }),
        DIVE_BOMB_PLAYER((manager, entity) -> {
            manager.m_31416_(EnderTrigonMod.DIVE_BOMB_PLAYER);
            ((DragonDiveBombPlayerPhase)manager.m_31418_(EnderTrigonMod.DIVE_BOMB_PLAYER)).setTarget((LivingEntity)entity);
        });

        private final BiConsumer<EnderDragonPhaseManager, LivingEntity> consumer;

        private AttackType(BiConsumer<EnderDragonPhaseManager, LivingEntity> consumer) {
            this.consumer = consumer;
        }

        public void activate(EnderDragonPhaseManager manager, LivingEntity target) {
            this.consumer.accept(manager, target);
        }

        public static AttackType random(RandomSource random, AttackType toExclude) {
            AttackType[] types = AttackType.values();
            if (ArrayUtils.contains((Object[])types, (Object)((Object)toExclude))) {
                types = (AttackType[])ArrayUtils.removeElement((Object[])types, (Object)((Object)toExclude));
            }
            return (AttackType)((Object)Util.m_214670_((Object[])types, (RandomSource)random));
        }
    }
}

