/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.storage.tracking;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataProcessor;
import com.teamabnormals.blueprint.common.world.storage.tracking.SyncType;
import java.util.function.Supplier;

public class TrackedData<T> {
    private final IDataProcessor<T> processor;
    private final Supplier<T> defaultValue;
    private final SyncType syncType;
    private final boolean save;
    private final boolean persistent;

    private TrackedData(IDataProcessor<T> processor, Supplier<T> defaultValue, SyncType syncType, boolean save, boolean persistent) {
        this.processor = processor;
        this.defaultValue = defaultValue;
        this.syncType = syncType;
        this.save = save;
        this.persistent = persistent;
    }

    public IDataProcessor<T> getProcessor() {
        return this.processor;
    }

    public SyncType getSyncType() {
        return this.syncType;
    }

    public T getDefaultValue() {
        return this.defaultValue.get();
    }

    public boolean shouldSave() {
        return this.save;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public static class Builder<T> {
        private final IDataProcessor<T> processor;
        private final Supplier<T> defaultValue;
        private SyncType syncType;
        private boolean save;
        private boolean persistent;

        private Builder(IDataProcessor<T> processor, Supplier<T> defaultValue) {
            this.processor = processor;
            this.defaultValue = defaultValue;
            this.syncType = SyncType.TO_CLIENTS;
        }

        public static <T> Builder<T> create(IDataProcessor<T> processor, Supplier<T> defaultValue) {
            return new Builder<T>(processor, defaultValue);
        }

        public Builder<T> setSyncType(SyncType syncType) {
            this.syncType = syncType;
            return this;
        }

        public Builder<T> enableSaving() {
            this.save = true;
            return this;
        }

        public Builder<T> enablePersistence() {
            this.persistent = true;
            return this;
        }

        public TrackedData<T> build() {
            return new TrackedData<T>(this.processor, this.defaultValue, this.syncType, this.save, this.persistent);
        }
    }
}

