/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.structure;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.common.world.modification.structure.SimpleStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterEntry;
import com.teamabnormals.blueprint.common.world.modification.structure.WeightedStructureRepaletter;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.registry.BasicRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blueprint")
public final class StructureRepalleterManager
extends SimpleJsonResourceReloadListener {
    static final BasicRegistry<Codec<? extends StructureRepaletter>> REPALLETER_SERIALIZERS = new BasicRegistry();
    private static final HashMap<ResourceLocation, StructureRepaletter[]> ASSIGNED_REPALLETERS = new HashMap(1);
    private static final ThreadLocal<ActiveData> ACTIVE_DATA = ThreadLocal.withInitial(ActiveData::new);
    private final RegistryAccess registryAccess;

    private StructureRepalleterManager(RegistryAccess registryAccess) {
        super(new Gson(), "structure_repalleters");
        this.registryAccess = registryAccess;
    }

    @SubscribeEvent
    public static void onReloadListener(AddReloadListenerEvent event) {
        try {
            event.addListener((PreparableReloadListener)new StructureRepalleterManager((RegistryAccess)DataUtil.REGISTRY_ACCESS.get(DataUtil.TAG_MANAGER.get(event.getServerResources()))));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static synchronized void registerSerializer(ResourceLocation name, Codec<? extends StructureRepaletter> codec) {
        REPALLETER_SERIALIZERS.register(name, codec);
    }

    public static void update(ResourceLocation location, RandomSource random) {
        StructureRepaletter[] repalettersForKey = ASSIGNED_REPALLETERS.get(location);
        if (repalettersForKey == null) {
            return;
        }
        ActiveData activeData = ACTIVE_DATA.get();
        Collections.addAll(activeData.repaletters, repalettersForKey);
        activeData.random = random;
    }

    public static BlockState getBlockState(ServerLevelAccessor level, BlockState state) {
        ActiveData activeData = ACTIVE_DATA.get();
        ArrayList<StructureRepaletter> activeRepaletters = activeData.repaletters;
        if (activeRepaletters.isEmpty()) {
            return state;
        }
        RandomSource random = activeData.random;
        for (StructureRepaletter repaletter : activeRepaletters) {
            BlockState repaletterState = repaletter.getReplacement(level, state, random);
            if (repaletterState == null) continue;
            return repaletterState;
        }
        return state;
    }

    public static void reset() {
        StructureRepalleterManager.ACTIVE_DATA.get().repaletters.clear();
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profilerFiller) {
        ASSIGNED_REPALLETERS.clear();
        RegistryAccess registryAccess = this.registryAccess;
        RegistryOps registryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
        Set structureLocations = ((Registry)registryAccess.m_6632_(Registry.f_235725_).orElseThrow()).m_6566_();
        HashMap<ResourceLocation, ArrayList> unorderedEntries = new HashMap<ResourceLocation, ArrayList>();
        int count = 0;
        for (Map.Entry<ResourceLocation, JsonElement> mapEntry : map.entrySet()) {
            ResourceLocation name = mapEntry.getKey();
            try {
                StructureRepaletterEntry entry = StructureRepaletterEntry.deserialize(name, mapEntry.getValue(), (DynamicOps<JsonElement>)registryOps);
                if (entry == null) continue;
                entry.selector().select(structureLocations::forEach).forEach(location -> unorderedEntries.computeIfAbsent((ResourceLocation)location, __ -> new ArrayList()).add(entry));
                ++count;
            }
            catch (JsonParseException exception) {
                Blueprint.LOGGER.error("Parsing error loading Structure Repaletter: {}", (Object)name, (Object)exception);
            }
        }
        unorderedEntries.forEach((location, repaletters) -> ASSIGNED_REPALLETERS.put((ResourceLocation)location, (StructureRepaletter[])repaletters.stream().sorted(Comparator.comparing(StructureRepaletterEntry::priority)).map(StructureRepaletterEntry::repaletter).toArray(StructureRepaletter[]::new)));
        Blueprint.LOGGER.info("Structure Repaletter Manager has loaded {} repaletters", (Object)count);
    }

    static {
        StructureRepalleterManager.registerSerializer(new ResourceLocation("blueprint", "simple"), SimpleStructureRepaletter.CODEC);
        StructureRepalleterManager.registerSerializer(new ResourceLocation("blueprint", "weighted"), WeightedStructureRepaletter.CODEC);
    }

    private static final class ActiveData {
        private final ArrayList<StructureRepaletter> repaletters = new ArrayList(0);
        private RandomSource random;

        private ActiveData() {
        }
    }
}

