/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.advancement.modification.modifiers;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierSerializers;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.AdvancementModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public record RewardsModifier(AdvancementModifier.Mode mode, Optional<Integer> experience, Optional<List<ResourceLocation>> loot, Optional<List<ResourceLocation>> recipes, Optional<ResourceLocation> function) implements AdvancementModifier<RewardsModifier>
{
    private static JsonArray serializeResourceList(List<ResourceLocation> resources) {
        JsonArray array = new JsonArray();
        resources.forEach(resourceLocation -> array.add(resourceLocation.toString()));
        return array;
    }

    private static Optional<List<ResourceLocation>> deserializeResourceList(JsonObject object, String key) {
        if (GsonHelper.m_13900_((JsonObject)object, (String)key)) {
            ArrayList resourceLocations = Lists.newArrayList();
            object.getAsJsonArray(key).forEach(element -> resourceLocations.add(new ResourceLocation(element.getAsString())));
            return Optional.of(resourceLocations);
        }
        return Optional.empty();
    }

    @Override
    public void modify(Advancement.Builder builder) {
        if (this.mode == AdvancementModifier.Mode.MODIFY) {
            AdvancementRewards rewards = builder.f_138335_;
            AdvancementRewards.Builder rewardsBuilder = new AdvancementRewards.Builder();
            rewardsBuilder.m_10007_(rewards.f_9979_);
            rewardsBuilder.f_10000_.addAll(Arrays.asList(rewards.f_9980_));
            for (ResourceLocation recipe : rewards.f_9981_) {
                rewardsBuilder.m_10011_(recipe);
            }
            rewardsBuilder.f_10002_ = rewards.f_9982_.m_77999_();
            this.experience.ifPresent(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).m_10007_(arg_0));
            this.loot.ifPresent(rewardsBuilder.f_10000_::addAll);
            this.recipes.ifPresent(rewardsBuilder.f_10001_::addAll);
            this.function.ifPresent(function -> {
                rewardsBuilder.f_10002_ = function;
            });
            builder.m_138354_(rewardsBuilder);
        } else {
            AdvancementRewards.Builder rewardsBuilder = new AdvancementRewards.Builder();
            this.experience.ifPresent(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).m_10007_(arg_0));
            this.loot.ifPresent(loot -> {
                rewardsBuilder.f_10000_.clear();
                rewardsBuilder.f_10000_.addAll(loot);
            });
            this.recipes.ifPresent(recipes -> {
                rewardsBuilder.f_10001_.clear();
                rewardsBuilder.f_10001_.addAll(recipes);
            });
            this.function.ifPresent(function -> {
                rewardsBuilder.f_10002_ = function;
            });
            builder.m_138354_(rewardsBuilder);
        }
    }

    public Serializer getSerializer() {
        return AdvancementModifierSerializers.REWARDS;
    }

    public static final class Serializer
    implements AdvancementModifier.Serializer<RewardsModifier> {
        @Override
        public JsonElement serialize(RewardsModifier modifier, Void additional) throws JsonParseException {
            JsonObject object = new JsonObject();
            modifier.mode.serialize(object);
            modifier.experience.ifPresent(experience -> object.addProperty("experience", (Number)experience));
            modifier.loot.ifPresent(loot -> object.add("loot", (JsonElement)RewardsModifier.serializeResourceList(loot)));
            modifier.recipes.ifPresent(recipes -> object.add("recipes", (JsonElement)RewardsModifier.serializeResourceList(recipes)));
            modifier.function.ifPresent(function -> object.addProperty("function", function.toString()));
            return object;
        }

        @Override
        public RewardsModifier deserialize(JsonElement element, DeserializationContext additional) throws JsonParseException {
            JsonObject object = element.getAsJsonObject();
            AdvancementModifier.Mode mode = AdvancementModifier.Mode.deserialize(object);
            Optional<Integer> experience = GsonHelper.m_13900_((JsonObject)object, (String)"experience") ? Optional.of(GsonHelper.m_13927_((JsonObject)object, (String)"experience")) : Optional.empty();
            Optional<List<ResourceLocation>> loot = RewardsModifier.deserializeResourceList(object, "loot");
            Optional<List<ResourceLocation>> recipes = RewardsModifier.deserializeResourceList(object, "recipes");
            Optional<ResourceLocation> function = GsonHelper.m_13900_((JsonObject)object, (String)"function") ? Optional.of(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"function"))) : Optional.empty();
            return new RewardsModifier(mode, experience, loot, recipes, function);
        }
    }
}

