/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.resources;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.resources.CachedResourcePath;
import org.embeddedt.modernfix.resources.ICachingResourcePack;
import org.embeddedt.modernfix.util.PackTypeHelper;

public class PackResourcesCacheEngine {
    private final Map<PackType, Set<String>> namespacesByType;
    private final Set<CachedResourcePath> containedPaths;
    private final EnumMap<PackType, Map<String, List<CachedResourcePath>>> resourceListings;
    private volatile boolean cacheGenerationFlag = false;
    private List<Runnable> cacheGenerationTasks = new ArrayList<Runnable>();
    private Path debugPath;
    private static final WeakHashMap<ICachingResourcePack, Boolean> cachingPacks = new WeakHashMap();

    public PackResourcesCacheEngine(Function<PackType, Set<String>> namespacesRetriever, BiFunction<PackType, String, Path> basePathRetriever) {
        this.namespacesByType = new EnumMap<PackType, Set<String>>(PackType.class);
        for (PackType type : PackType.values()) {
            if (!PackTypeHelper.isVanillaPackType(type)) continue;
            this.namespacesByType.put(type, namespacesRetriever.apply(type));
        }
        this.containedPaths = new ObjectOpenHashSet();
        this.resourceListings = new EnumMap(PackType.class);
        this.debugPath = basePathRetriever.apply(PackType.CLIENT_RESOURCES, "minecraft").toAbsolutePath();
        for (PackType type : PackType.values()) {
            Collection namespaces = PackTypeHelper.isVanillaPackType(type) ? (Collection)this.namespacesByType.get(type) : (Collection)namespacesRetriever.apply(type);
            Collection namespacedRoots = namespaces.stream().map(s -> Pair.of((Object)s, (Object)((Path)basePathRetriever.apply(type, (String)s)).toAbsolutePath())).collect(Collectors.toList());
            this.cacheGenerationTasks.add(() -> {
                ImmutableMap.Builder packTypedMap = ImmutableMap.builder();
                for (Pair pair : namespacedRoots) {
                    try {
                        ImmutableList.Builder namespacedList = ImmutableList.builder();
                        String namespace = (String)pair.getFirst();
                        Path root = (Path)pair.getSecond();
                        String[] prefix = new String[]{type.m_10305_(), namespace};
                        try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
                            stream.map(path -> root.relativize(path.toAbsolutePath())).filter(PackResourcesCacheEngine::isValidCachedResourcePath).forEach(path -> {
                                CachedResourcePath cachedPath = new CachedResourcePath(prefix, (Path)path);
                                Set<CachedResourcePath> set = this.containedPaths;
                                synchronized (set) {
                                    this.containedPaths.add(cachedPath);
                                }
                                if (!cachedPath.getFileName().endsWith(".mcmeta")) {
                                    namespacedList.add((Object)cachedPath);
                                }
                            });
                        }
                        packTypedMap.put((Object)namespace, (Object)namespacedList.build());
                    }
                    catch (IOException iOException) {}
                }
                EnumMap<PackType, Map<String, List<CachedResourcePath>>> enumMap = this.resourceListings;
                synchronized (enumMap) {
                    this.resourceListings.put(type, (Map<String, List<CachedResourcePath>>)packTypedMap.build());
                }
            });
        }
        this.cacheGenerationTasks.add(() -> ((ObjectOpenHashSet)this.containedPaths).trim());
    }

    private static boolean isValidCachedResourcePath(Path path) {
        if (path.getFileName() == null || path.getNameCount() == 0) {
            return false;
        }
        String str = path.toString();
        if (str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (ResourceLocation.m_135828_((char)str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Set<String> getNamespaces(PackType type) {
        if (PackTypeHelper.isVanillaPackType(type)) {
            return this.namespacesByType.get(type);
        }
        return null;
    }

    private void doGenerateCache() {
        Stopwatch watch = Stopwatch.createStarted();
        for (Runnable r : this.cacheGenerationTasks) {
            r.run();
        }
        watch.stop();
        ModernFix.LOGGER.debug("Generated cache for {} in {}", (Object)this.debugPath, (Object)watch);
        this.debugPath = null;
        this.cacheGenerationTasks = ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitLoad() {
        if (!this.cacheGenerationFlag) {
            PackResourcesCacheEngine packResourcesCacheEngine = this;
            synchronized (packResourcesCacheEngine) {
                if (!this.cacheGenerationFlag) {
                    this.doGenerateCache();
                    this.cacheGenerationFlag = true;
                }
            }
        }
    }

    public boolean hasResource(String path) {
        this.awaitLoad();
        return this.containedPaths.contains(new CachedResourcePath(path));
    }

    public Collection<ResourceLocation> getResources(PackType type, String resourceNamespace, String pathIn, int maxDepth, Predicate<ResourceLocation> filter) {
        if (!PackTypeHelper.isVanillaPackType(type)) {
            throw new IllegalArgumentException("Only vanilla PackTypes are supported");
        }
        this.awaitLoad();
        List paths = this.resourceListings.get(type).getOrDefault(resourceNamespace, Collections.emptyList());
        if (paths.isEmpty()) {
            return Collections.emptyList();
        }
        Object testPath = pathIn.endsWith("/") ? pathIn : pathIn + "/";
        ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
        for (CachedResourcePath cachePath : paths) {
            ResourceLocation foundResource;
            String fullPath;
            if (cachePath.getNameCount() - 2 > maxDepth || !(fullPath = cachePath.getFullPath(2)).startsWith((String)testPath) || !filter.test(foundResource = new ResourceLocation(resourceNamespace, fullPath))) continue;
            resources.add(foundResource);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void track(ICachingResourcePack pack) {
        WeakHashMap<ICachingResourcePack, Boolean> weakHashMap = cachingPacks;
        synchronized (weakHashMap) {
            cachingPacks.put(pack, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate() {
        if (!ModernFixPlatformHooks.isDevEnv()) {
            return;
        }
        WeakHashMap<ICachingResourcePack, Boolean> weakHashMap = cachingPacks;
        synchronized (weakHashMap) {
            cachingPacks.keySet().forEach(pack -> {
                if (pack != null) {
                    pack.invalidateCache();
                }
            });
        }
    }
}

