/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.ForgeItemModelShaper;
import net.minecraftforge.registries.ForgeRegistries;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.dynamicresources.ModelLocationCache;
import org.embeddedt.modernfix.util.ItemMesherMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ForgeItemModelShaper.class})
@ClientOnlyMixin
public abstract class ItemModelMesherForgeMixin
extends ItemModelShaper {
    @Shadow
    @Final
    @Mutable
    private Map<Holder.Reference<Item>, ModelResourceLocation> locations;
    private Map<Holder.Reference<Item>, ModelResourceLocation> overrideLocations;
    private static final ModelResourceLocation SENTINEL = new ModelResourceLocation("modernfix", "sentinel");

    public ItemModelMesherForgeMixin(ModelManager arg) {
        super(arg);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void replaceLocationMap(CallbackInfo ci) {
        this.overrideLocations = new HashMap<Holder.Reference<Item>, ModelResourceLocation>();
        this.locations = new ItemMesherMap<Holder.Reference>(this::mfix$getLocationForge);
    }

    @Unique
    private ModelResourceLocation mfix$getLocationForge(Holder.Reference<Item> item) {
        ModelResourceLocation map = this.overrideLocations.getOrDefault(item, SENTINEL);
        if (map == SENTINEL) {
            map = ModelLocationCache.get((Item)item.get());
        }
        return map;
    }

    @Overwrite
    public BakedModel m_109394_(Item item) {
        ModelResourceLocation map = this.mfix$getLocationForge((Holder.Reference<Item>)ForgeRegistries.ITEMS.getDelegateOrThrow((Object)item));
        return map == null ? null : this.m_109393_().m_119422_(map);
    }

    @Overwrite
    public void m_109396_(Item item, ModelResourceLocation location) {
        this.overrideLocations.put((Holder.Reference<Item>)ForgeRegistries.ITEMS.getDelegateOrThrow((Object)item), location);
    }

    @Overwrite
    public void m_109403_() {
    }
}

