/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;

public class ModelLocationCache {
    private static final LoadingCache<BlockState, ModelResourceLocation> blockLocationCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<BlockState, ModelResourceLocation>(){

        public ModelResourceLocation load(BlockState key) throws Exception {
            return BlockModelShaper.m_110895_((BlockState)key);
        }
    });
    private static final LoadingCache<Item, ModelResourceLocation> itemLocationCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Item, ModelResourceLocation>(){

        public ModelResourceLocation load(Item key) throws Exception {
            return new ModelResourceLocation(Registry.f_122827_.m_7981_((Object)key), "inventory");
        }
    });

    public static ModelResourceLocation get(BlockState state) {
        if (state == null) {
            return null;
        }
        try {
            return (ModelResourceLocation)blockLocationCache.get((Object)state);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static ModelResourceLocation get(Item item) {
        if (item == null) {
            return null;
        }
        try {
            return (ModelResourceLocation)itemLocationCache.get((Object)item);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

