/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Triple;
import org.embeddedt.modernfix.ModernFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBakedModelProvider
implements Map<ResourceLocation, BakedModel> {
    private final ModelBakery bakery;
    private final Map<Triple<ResourceLocation, Transformation, Boolean>, BakedModel> bakedCache;
    private final Map<ResourceLocation, BakedModel> permanentOverrides;
    private BakedModel missingModel;
    private static final BakedModel SENTINEL = new BakedModel(){

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
            return null;
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return null;
        }

        public ItemTransforms m_7442_() {
            return null;
        }

        public ItemOverrides m_7343_() {
            return null;
        }
    };

    public DynamicBakedModelProvider(ModelBakery bakery, Map<Triple<ResourceLocation, Transformation, Boolean>, BakedModel> cache) {
        this.bakery = bakery;
        this.bakedCache = cache;
        this.permanentOverrides = new Object2ObjectOpenHashMap();
    }

    public void setMissingModel(BakedModel model) {
        this.missingModel = model;
    }

    private static Triple<ResourceLocation, Transformation, Boolean> vanillaKey(Object o) {
        return Triple.of((Object)((ResourceLocation)o), (Object)BlockModelRotation.X0_Y0.m_6189_(), (Object)false);
    }

    @Override
    public int size() {
        return this.bakedCache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bakedCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.permanentOverrides.getOrDefault(o, SENTINEL) != null;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.permanentOverrides.containsValue(o) || this.bakedCache.containsValue(o);
    }

    @Override
    public BakedModel get(Object o) {
        BakedModel model = this.permanentOverrides.getOrDefault(o, SENTINEL);
        if (model != SENTINEL) {
            return model;
        }
        try {
            model = this.bakery.m_119349_((ResourceLocation)o, (ModelState)BlockModelRotation.X0_Y0);
        }
        catch (RuntimeException e) {
            ModernFix.LOGGER.error("Exception baking {}: {}", o, (Object)e);
            model = this.missingModel;
        }
        if (model == this.missingModel) {
            this.permanentOverrides.put((ResourceLocation)o, null);
            return null;
        }
        return model;
    }

    @Override
    public BakedModel put(ResourceLocation resourceLocation, BakedModel bakedModel) {
        BakedModel m = this.permanentOverrides.put(resourceLocation, bakedModel);
        if (m != null) {
            return m;
        }
        return this.bakedCache.get(DynamicBakedModelProvider.vanillaKey(resourceLocation));
    }

    @Override
    public BakedModel remove(Object o) {
        BakedModel m = this.permanentOverrides.remove(o);
        if (m != null) {
            return m;
        }
        return this.bakedCache.remove(DynamicBakedModelProvider.vanillaKey(o));
    }

    @Override
    public void putAll(@NotNull Map<? extends ResourceLocation, ? extends BakedModel> map) {
        this.permanentOverrides.putAll(map);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<ResourceLocation> keySet() {
        return this.bakedCache.keySet().stream().map(Triple::getLeft).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<BakedModel> values() {
        return this.bakedCache.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<ResourceLocation, BakedModel>> entrySet() {
        return this.bakedCache.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<ResourceLocation, BakedModel>((ResourceLocation)((Triple)entry.getKey()).getLeft(), (BakedModel)entry.getValue())).collect(Collectors.toSet());
    }

    @Override
    public void replaceAll(BiFunction<? super ResourceLocation, ? super BakedModel, ? extends BakedModel> function) {
        Set<ResourceLocation> overridenLocations = this.permanentOverrides.keySet();
        this.permanentOverrides.replaceAll(function);
        boolean uvLock = BlockModelRotation.X0_Y0.m_7538_();
        Transformation rotation = BlockModelRotation.X0_Y0.m_6189_();
        this.bakedCache.replaceAll((? super K loc, ? super V oldModel) -> {
            if (loc.getMiddle() != rotation || (Boolean)loc.getRight() != uvLock || overridenLocations.contains(loc.getLeft())) {
                return oldModel;
            }
            return (BakedModel)function.apply((ResourceLocation)loc.getLeft(), (BakedModel)oldModel);
        });
    }
}

