/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.core.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class ModernFixEarlyConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"ModernFixConfig");
    private final Map<String, Option> options = new HashMap<String, Option>();
    public static final boolean OPTIFINE_PRESENT;
    private File configFile;
    private static final String MIXIN_DESC = "Lorg/spongepowered/asm/mixin/Mixin;";
    private static final String MIXIN_CLIENT_ONLY_DESC = "Lorg/embeddedt/modernfix/annotation/ClientOnlyMixin;";
    private static final String MIXIN_REQUIRES_MOD_DESC = "Lorg/embeddedt/modernfix/annotation/RequiresMod;";
    private static final Pattern PLATFORM_PREFIX;
    private final Set<String> mixinOptions = new ObjectOpenHashSet();
    private final Map<String, String> mixinsMissingMods = new Object2ObjectOpenHashMap();
    public static boolean isFabric;
    private static final boolean isDevEnv;
    private static final ImmutableMap<String, Boolean> DEFAULT_SETTING_OVERRIDES;

    private static boolean modPresent(String modId) {
        if (modId.equals("optifine")) {
            return OPTIFINE_PRESENT;
        }
        return ModernFixPlatformHooks.modPresent(modId);
    }

    public static String sanitize(String mixinClassName) {
        return PLATFORM_PREFIX.matcher(mixinClassName).replaceFirst("");
    }

    public Map<String, String> getPermanentlyDisabledMixins() {
        return this.mixinsMissingMods;
    }

    private void scanForAndBuildMixinOptions() {
        ImmutableList configFiles = ImmutableList.of((Object)"modernfix-common.mixins.json", (Object)"modernfix-fabric.mixins.json", (Object)"modernfix-forge.mixins.json");
        ArrayList<CallSite> mixinPaths = new ArrayList<CallSite>();
        for (String configFile : configFiles) {
            InputStream inputStream = ModernFixEarlyConfig.class.getClassLoader().getResourceAsStream(configFile);
            if (inputStream == null) continue;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                if (configFile.contains("fabric")) {
                    isFabric = true;
                }
                JsonObject configObject = (JsonObject)new JsonParser().parse((Reader)reader);
                JsonArray mixinList = configObject.getAsJsonArray("mixins");
                String packageName = configObject.get("package").getAsString().replace('.', '/');
                for (JsonElement mixin : mixinList) {
                    mixinPaths.add((CallSite)((Object)(packageName + "/" + mixin.getAsString().replace('.', '/') + ".class")));
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.error("Error loading config " + configFile, e);
            }
        }
        Splitter dotSplitter = Splitter.on((char)'.');
        for (String string : mixinPaths) {
            try {
                InputStream stream = ModernFixEarlyConfig.class.getClassLoader().getResourceAsStream(string);
                try {
                    ClassReader reader = new ClassReader(stream);
                    ClassNode node = new ClassNode();
                    reader.accept((ClassVisitor)node, 7);
                    if (node.invisibleAnnotations == null) {
                        return;
                    }
                    boolean isMixin = false;
                    boolean isClientOnly = false;
                    boolean requiredModPresent = true;
                    String requiredModId = "";
                    block18: for (AnnotationNode annotation : node.invisibleAnnotations) {
                        if (Objects.equals(annotation.desc, MIXIN_DESC)) {
                            isMixin = true;
                            continue;
                        }
                        if (Objects.equals(annotation.desc, MIXIN_CLIENT_ONLY_DESC)) {
                            isClientOnly = true;
                            continue;
                        }
                        if (!Objects.equals(annotation.desc, MIXIN_REQUIRES_MOD_DESC)) continue;
                        for (int i = 0; i < annotation.values.size(); i += 2) {
                            if (!annotation.values.get(i).equals("value")) continue;
                            String modId = (String)annotation.values.get(i + 1);
                            if (modId == null) continue block18;
                            requiredModPresent = ModernFixEarlyConfig.modPresent(modId);
                            requiredModId = modId;
                            continue block18;
                        }
                    }
                    if (!isMixin) continue;
                    String mixinClassName = ModernFixEarlyConfig.sanitize(node.name.replace('/', '.')).replace("org.embeddedt.modernfix.mixin.", "");
                    if (!requiredModPresent) {
                        this.mixinsMissingMods.put(mixinClassName, requiredModId);
                    } else if (isClientOnly && !ModernFixPlatformHooks.isClient()) {
                        this.mixinsMissingMods.put(mixinClassName, "[not client]");
                    }
                    List mixinOptionNames = dotSplitter.splitToList((CharSequence)mixinClassName);
                    StringBuilder optionBuilder = new StringBuilder(mixinClassName.length());
                    optionBuilder.append("mixin");
                    for (int i = 0; i < mixinOptionNames.size() - 1; ++i) {
                        optionBuilder.append('.');
                        optionBuilder.append((String)mixinOptionNames.get(i));
                        this.mixinOptions.add(optionBuilder.toString());
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                ModernFix.LOGGER.error("Error scanning file " + string, (Throwable)e);
            }
        }
    }

    private ModernFixEarlyConfig(File file) {
        this.configFile = file;
        this.scanForAndBuildMixinOptions();
        this.mixinOptions.addAll((Collection<String>)DEFAULT_SETTING_OVERRIDES.keySet());
        if (!isFabric) {
            this.mixinOptions.add("mixin.bugfix.fix_config_crashes");
        }
        for (String optionName : this.mixinOptions) {
            boolean defaultEnabled = (Boolean)DEFAULT_SETTING_OVERRIDES.getOrDefault((Object)optionName, (Object)true);
            this.options.putIfAbsent(optionName, new Option(optionName, defaultEnabled, false));
        }
        this.addMixinRule("launch.class_search_cache", true);
        this.disableIfModPresent("mixin.perf.thread_priorities", "smoothboot");
        this.disableIfModPresent("mixin.perf.boost_worker_count", "smoothboot");
        this.disableIfModPresent("mixin.perf.async_jei", "modernui");
        this.disableIfModPresent("mixin.perf.compress_biome_container", "chocolate", "betterendforge", "skyblockbuilder");
        this.disableIfModPresent("mixin.bugfix.mc218112", "performant");
        this.disableIfModPresent("mixin.bugfix.remove_block_chunkloading", "performant");
        this.disableIfModPresent("mixin.bugfix.paper_chunk_patches", "c2me");
        this.disableIfModPresent("mixin.perf.nbt_memory_usage", "c2me");
        this.disableIfModPresent("mixin.bugfix.chunk_deadlock", "c2me", "dimthread");
        this.disableIfModPresent("mixin.perf.reuse_datapacks", "tac");
        this.disableIfModPresent("mixin.launch.class_search_cache", "optifine");
        this.disableIfModPresent("mixin.perf.faster_texture_stitching", "optifine");
        this.disableIfModPresent("mixin.perf.datapack_reload_exceptions", "cyanide");
        this.disableIfModPresent("mixin.perf.faster_texture_loading", "stitch", "optifine", "changed");
        if (isFabric) {
            this.disableIfModPresent("mixin.bugfix.packet_leak", "memoryleakfix");
        }
    }

    private void disableIfModPresent(String configName, String ... ids) {
        for (String id : ids) {
            Option option;
            if (!ModernFixEarlyConfig.modPresent(id) || (option = this.options.get(configName)) == null) continue;
            option.addModOverride(false, id);
        }
    }

    private void addMixinRule(String mixin, boolean enabled) {
        String name = ModernFixEarlyConfig.getMixinRuleName(mixin);
        if (this.options.putIfAbsent(name, new Option(name, enabled, false)) != null) {
            throw new IllegalStateException("Mixin rule already defined: " + mixin);
        }
    }

    private void readProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            boolean enabled;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Option option = this.options.get(key);
            if (option == null) {
                LOGGER.warn("No configuration key exists with name '{}', ignoring", (Object)key);
                continue;
            }
            if (value.equalsIgnoreCase("true")) {
                enabled = true;
            } else if (value.equalsIgnoreCase("false")) {
                enabled = false;
            } else {
                LOGGER.warn("Invalid value '{}' encountered for configuration key '{}', ignoring", (Object)value, (Object)key);
                continue;
            }
            option.setEnabled(enabled, true);
        }
    }

    public Option getEffectiveOptionForMixin(String mixinClassName) {
        int nextSplit;
        int lastSplit = 0;
        Option rule = null;
        while ((nextSplit = mixinClassName.indexOf(46, lastSplit)) != -1) {
            String key = ModernFixEarlyConfig.getMixinRuleName(mixinClassName.substring(0, nextSplit));
            Option candidate = this.options.get(key);
            if (candidate != null && !(rule = candidate).isEnabled()) {
                return rule;
            }
            lastSplit = nextSplit + 1;
        }
        return rule;
    }

    public static ModernFixEarlyConfig load(File file) {
        ModernFixEarlyConfig config = new ModernFixEarlyConfig(file);
        Properties props = new Properties();
        if (file.exists()) {
            try (FileInputStream fin = new FileInputStream(file);){
                props.load(fin);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load config file", e);
            }
            config.readProperties(props);
        }
        try {
            config.save();
        }
        catch (IOException e) {
            LOGGER.warn("Could not write configuration file", (Throwable)e);
        }
        return config;
    }

    public void save() throws IOException {
        File dir = this.configFile.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(this.configFile);){
            writer.write("# This is the configuration file for ModernFix.\n");
            writer.write("#\n");
            writer.write("# The following options can be enabled or disabled if there is a compatibility issue.\n");
            writer.write("# Add a line mixin.example_name=true/false without the # sign to enable/disable a rule.\n");
            List keys = this.options.keySet().stream().filter(key -> !key.equals("mixin.core")).sorted().collect(Collectors.toList());
            for (String line : keys) {
                if (line.equals("mixin.core")) continue;
                writer.write("#  " + line + "\n");
            }
            for (String key2 : keys) {
                Option option = this.options.get(key2);
                if (!option.isUserDefined()) continue;
                writer.write(key2 + "=" + option.isEnabled() + "\n");
            }
        }
    }

    private static String getMixinRuleName(String name) {
        return "mixin." + name;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public int getOptionOverrideCount() {
        return (int)this.options.values().stream().filter(Option::isOverridden).count();
    }

    public Map<String, Option> getOptionMap() {
        return Collections.unmodifiableMap(this.options);
    }

    static {
        boolean hasOfClass = false;
        try {
            Class.forName("optifine.OptiFineTransformationService");
            hasOfClass = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OPTIFINE_PRESENT = hasOfClass;
        PLATFORM_PREFIX = Pattern.compile("(forge|fabric|common)\\.");
        isFabric = false;
        isDevEnv = ModernFixPlatformHooks.isDevEnv();
        DEFAULT_SETTING_OVERRIDES = ImmutableMap.builder().put((Object)"mixin.perf.dynamic_resources", (Object)false).put((Object)"mixin.feature.direct_stack_trace", (Object)false).put((Object)"mixin.perf.rewrite_registry", (Object)false).put((Object)"mixin.perf.clear_mixin_classinfo", (Object)false).put((Object)"mixin.perf.compress_blockstate", (Object)false).put((Object)"mixin.bugfix.packet_leak", (Object)false).put((Object)"mixin.perf.deduplicate_location", (Object)false).put((Object)"mixin.perf.dynamic_entity_renderers", (Object)false).put((Object)"mixin.feature.integrated_server_watchdog", (Object)true).put((Object)"mixin.perf.faster_item_rendering", (Object)false).put((Object)"mixin.feature.spam_thread_dump", (Object)false).put((Object)"mixin.feature.snapshot_easter_egg", (Object)true).put((Object)"mixin.devenv", (Object)isDevEnv).put((Object)"mixin.perf.remove_spawn_chunks", (Object)isDevEnv).build();
    }
}

