/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.api.helpers;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.embeddedt.modernfix.util.DynamicMap;

public final class ModelHelpers {
    public static ImmutableList<BlockState> getBlockStateForLocation(ModelResourceLocation location) {
        Optional blockOpt = Registry.f_122824_.m_6612_(new ResourceLocation(location.m_135827_(), location.m_135815_()));
        if (blockOpt.isPresent()) {
            return ModelBakeryHelpers.getBlockStatesForMRL((StateDefinition<Block, BlockState>)((Block)blockOpt.get()).m_49965_(), location);
        }
        return ImmutableList.of();
    }

    public static ImmutableList<BlockState> getBlockStateForLocation(StateDefinition<Block, BlockState> definition, ModelResourceLocation location) {
        return ModelBakeryHelpers.getBlockStatesForMRL(definition, location);
    }

    public static Map<ResourceLocation, BakedModel> createFakeTopLevelMap(BiFunction<ResourceLocation, ModelState, BakedModel> modelGetter) {
        return new DynamicMap<ResourceLocation, BakedModel>(location -> (BakedModel)modelGetter.apply((ResourceLocation)location, (ModelState)BlockModelRotation.X0_Y0));
    }
}

