/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix;

import java.lang.management.ManagementFactory;
import java.util.concurrent.ExecutorService;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.command.ModernFixCommands;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.resources.ReloadExecutor;
import org.embeddedt.modernfix.util.ClassInfoManager;
import org.embeddedt.modernfix.world.IntegratedWatchdog;

public class ModernFix {
    public static final Logger LOGGER = LogManager.getLogger((String)"ModernFix");
    public static final String MODID = "modernfix";
    public static String NAME = "ModernFix";
    public static ModernFix INSTANCE;
    public static boolean runningFirstInjection;
    private static ExecutorService resourceReloadService;

    public static ExecutorService resourceReloadExecutor() {
        return resourceReloadService;
    }

    public ModernFix() {
        INSTANCE = this;
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.snapshot_easter_egg.NameChange") && !SharedConstants.m_183709_().isStable()) {
            NAME = "PreemptiveFix";
        }
        ModernFixPlatformHooks.onServerCommandRegister(ModernFixCommands::register);
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.spam_thread_dump.ThreadDumper")) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        LOGGER.error("------ DEBUG THREAD DUMP (occurs every 60 seconds) ------");
                        LOGGER.error(IntegratedWatchdog.obtainThreadDump());
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    public void onServerStarted() {
        if (ModernFixPlatformHooks.isDedicatedServer()) {
            float gameStartTime = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
            LOGGER.warn("Dedicated server took " + gameStartTime + " seconds to load");
        }
        ClassInfoManager.clear();
    }

    public void onLoadComplete() {
        ClassInfoManager.clear();
    }

    public void onServerDead(MinecraftServer server) {
        try {
            for (ServerLevel level : server.m_129785_()) {
                ChunkMap chunkMap = level.m_7726_().f_8325_;
                chunkMap.f_140129_.clear();
                chunkMap.f_140130_.clear();
                chunkMap.f_140131_.clear();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Couldn't clear chunk data", (Throwable)e);
        }
    }

    static {
        runningFirstInjection = false;
        resourceReloadService = null;
        resourceReloadService = ModernFixMixinPlugin.instance.isOptionEnabled("perf.dedicated_reload_executor.ReloadExecutor") ? ReloadExecutor.createCustomResourceReloadExecutor() : Util.m_183991_();
    }
}

