/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.Network.DataRequestType;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.TeleportMessage;
import com.darkere.crashutils.Screens.CUButton;
import com.darkere.crashutils.Screens.CUContentPane;
import com.darkere.crashutils.Screens.CUDropDown;
import com.darkere.crashutils.Screens.CUTab;
import com.darkere.crashutils.Screens.DataListGUI;
import com.darkere.crashutils.Screens.GuiTools;
import com.darkere.crashutils.Screens.MapGUI;
import com.darkere.crashutils.Screens.Types.DropDownType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class CUScreen
extends Screen {
    public static CUScreen stored;
    CUContentPane contentGUI;
    long doubleClickTimer;
    double oldClickX;
    double OldClickY;
    ResourceKey<Level> dim;
    int centerX;
    int centerY;
    int activeTab = 0;
    int tabs = 2;
    private static final ResourceLocation WINDOW;
    private static final ResourceLocation TABS;
    public List<CUDropDown> topDropDowns = new ArrayList<CUDropDown>();
    CUButton updateButton;
    CUButton backButton;
    boolean dragging;
    BlockPos initial;
    static boolean keep;

    public CUScreen(ResourceKey<Level> worldKey, BlockPos position) {
        super((Component)CommandUtils.CreateTextComponent("CUScreen"));
        this.dim = worldKey;
        this.initial = position;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.centerY = this.f_96544_ / 2;
        this.centerX = this.f_96543_ / 2;
        if (!keep) {
            this.contentGUI = new MapGUI(this, this.dim, this.initial);
            DataHolder.setRequestType(DataRequestType.LOADEDCHUNKDATA);
        }
        ArrayList<Object> updateButtonText = new ArrayList<Object>();
        updateButtonText.add("Requesting data every " + this.contentGUI.updateSpeed + " seconds");
        updateButtonText.add("Scroll to change update Speed");
        this.updateButton = new CUButton(this.centerX + 174, this.centerY - 103, 20, 10, (Component)CommandUtils.CreateTextComponent(String.valueOf(this.contentGUI.updateSpeed)), x -> {
            this.contentGUI.shouldUpdate = !this.contentGUI.shouldUpdate;
            this.contentGUI.setUpdateSpeed();
        }, (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, updateButtonText, x, y, (Screen)this));
        this.m_7787_((GuiEventListener)this.updateButton);
        this.backButton = new CUButton(this.centerX + 145, this.centerY - 103, 20, 10, (Component)CommandUtils.CreateTextComponent("<-"), button -> {
            if (this.contentGUI instanceof DataListGUI) {
                ((DataListGUI)this.contentGUI).loader.goBack();
            } else if (this.contentGUI instanceof MapGUI) {
                ((MapGUI)this.contentGUI).goTo(((MapGUI)this.contentGUI).initial);
            }
        }, (button, stack, x, y) -> GuiTools.drawTextToolTip(stack, this.contentGUI instanceof MapGUI ? "Return to player" : "Go Back", x, y, (Screen)this)){

            public boolean m_142518_() {
                if (CUScreen.this.contentGUI instanceof DataListGUI) {
                    return ((DataListGUI)CUScreen.this.contentGUI).loader.history.size() > 1;
                }
                return super.m_142518_();
            }
        };
        this.m_7787_((GuiEventListener)this.backButton);
    }

    public void m_7333_(PoseStack stack) {
        assert (this.f_96541_ != null);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW);
        int i = this.centerX - 200;
        int j = this.centerY - 108;
        CUScreen.m_93133_((PoseStack)stack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)400, (int)216, (int)512, (int)512);
        this.renderTabs(stack);
    }

    public void m_6305_(PoseStack stack, int mx, int my, float partialTicks) {
        this.m_7333_(stack);
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        CUScreen.m_93172_((PoseStack)stack, (int)(this.centerX + 173), (int)(this.centerY - 105), (int)(this.centerX + 195), (int)(this.centerY - 93), (int)(this.contentGUI.shouldUpdate ? -11406014 : -703934));
        this.updateButton.f_93620_ = this.centerX + 174;
        this.updateButton.f_93621_ = this.centerY - 104;
        this.backButton.f_93620_ = this.centerX + 145;
        this.backButton.f_93621_ = this.centerY - 103;
        this.updateButton.m_6303_(stack, mx, my, partialTicks);
        this.backButton.m_6303_(stack, mx, my, partialTicks);
        this.contentGUI.render(stack, this.centerX, this.centerY, mx, my, partialTicks);
        this.topDropDowns.forEach(x -> x.render(stack, this.centerX, this.centerY));
        this.renderToolTips(stack, mx, my);
        super.m_6305_(stack, mx, my, partialTicks);
    }

    private void renderToolTips(PoseStack stack, int mx, int my) {
        ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
        if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY) && this.contentGUI instanceof MapGUI) {
            MapGUI gui = (MapGUI)this.contentGUI;
            ChunkPos chunkPos = gui.getChunkFor(mx, my);
            tooltips.add(CommandUtils.CreateTextComponent("Chunk: X: " + chunkPos.f_45578_ + " Z: " + chunkPos.f_45579_));
            String loc = gui.getLocFor(mx, my);
            tooltips.add(CommandUtils.CreateTextComponent("State: " + gui.getNameForLocationType(loc)));
            StringBuilder builder = new StringBuilder();
            switch (gui.type) {
                case TICKET: 
                case LOCATIONTYPE: {
                    builder.append("Tickets: ");
                    String tickets = gui.getTicketsFor(mx, my);
                    builder.append(tickets == null ? "None" : tickets);
                    break;
                }
                case ENTITIES: {
                    builder.append("Entities: ");
                    String entities = gui.getEntityCountFor(mx, my);
                    builder.append(entities == null ? "None" : entities);
                    break;
                }
                case TILEENTITIES: {
                    builder.append("Tileentities: ");
                    String tileEntities = gui.getTileEntityCountFor(mx, my);
                    builder.append(tileEntities == null ? "None" : tileEntities);
                }
            }
            tooltips.add(CommandUtils.CreateTextComponent(builder.toString()));
            tooltips.add(CommandUtils.CreateTextComponent("(Double click to teleport)"));
        }
        if (!tooltips.isEmpty()) {
            this.renderTooltip(stack, tooltips, Optional.empty(), mx, my, Minecraft.m_91087_().f_91062_);
        }
    }

    private void renderTabs(PoseStack stack) {
        int x = this.centerX - 200;
        int y = this.centerY - 108 - 22;
        assert (this.f_96541_ != null);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TABS);
        float iconScale = 3.75f;
        ArrayList<CUTab> tabIcons = new ArrayList<CUTab>();
        tabIcons.add(CUTab.MAPTABICON);
        tabIcons.add(CUTab.LISTTABICON);
        tabIcons.add(CUTab.INVSEETABICON);
        for (int i = 0; i < this.tabs; ++i) {
            if (i == 0) {
                if (i == this.activeTab) {
                    CUTab.ATL.drawTab(stack, (GuiComponent)this, x, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
                    continue;
                }
                CUTab.ITL.drawTab(stack, (GuiComponent)this, x, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
                continue;
            }
            if (i == this.activeTab) {
                CUTab.ATC.drawTab(stack, (GuiComponent)this, x + i * 27, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
                continue;
            }
            CUTab.ITC.drawTab(stack, (GuiComponent)this, x + i * 27, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
        DataHolder.cancelTimer();
        DataHolder.stopListening();
        stored = this;
    }

    public boolean m_7979_(double XStart, double YStart, int Button2, double XDif, double YDif) {
        if (this.dragging) {
            this.contentGUI.addOffset(-XDif, -YDif);
            return true;
        }
        return super.m_7979_(XStart, YStart, Button2, XDif, YDif);
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (p_mouseReleased_5_ == 0) {
            this.dragging = false;
        }
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean m_6375_(double mx, double my, int mouseButton) {
        for (CUDropDown cUDropDown : this.topDropDowns) {
            if (!cUDropDown.checkClick((int)mx, (int)my)) continue;
            return true;
        }
        if (this.contentGUI.mouseClickedOutside(mx, my, this.centerX, this.centerY, mouseButton)) {
            return true;
        }
        if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY)) {
            this.dragging = true;
            if (this.contentGUI.mouseClicked(mx, my, mouseButton)) {
                return true;
            }
        }
        if (my > (double)(this.centerY - 126) && my < (double)(this.centerY - 107)) {
            return this.clickedTabArea(mx, my, mouseButton);
        }
        if (Instant.now().getEpochSecond() - this.doubleClickTimer < 1L) {
            if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY)) {
                if (Math.sqrt((this.oldClickX - mx) * (this.oldClickX - mx) + (this.OldClickY - my) * (this.OldClickY - my)) > 5.0) {
                    return super.m_6375_(mx, my, mouseButton);
                }
                CUContentPane cUContentPane = this.contentGUI;
                if (cUContentPane instanceof MapGUI) {
                    MapGUI gui = (MapGUI)cUContentPane;
                    BlockPos blockPos = gui.getChunkFor((int)mx, (int)my).m_45615_();
                    Network.sendToServer(new TeleportMessage(this.dim, this.dim, blockPos));
                    return true;
                }
            }
        } else {
            this.doubleClickTimer = Instant.now().getEpochSecond();
            this.oldClickX = mx;
            this.OldClickY = my;
        }
        return super.m_6375_(mx, my, mouseButton);
    }

    private boolean clickedTabArea(double mx, double my, int mouseButton) {
        int x = (int)mx - (this.centerX - 198);
        int tab = x / 27;
        if (tab >= this.tabs) {
            return false;
        }
        this.activeTab = tab;
        this.switchTabs();
        return true;
    }

    private void switchTabs() {
        this.topDropDowns.clear();
        switch (this.activeTab) {
            case 0: {
                this.contentGUI = new MapGUI(this, this.dim, this.initial);
                keep = false;
                break;
            }
            case 1: {
                this.contentGUI = new DataListGUI(this, this.dim);
                keep = true;
            }
        }
    }

    public boolean m_6050_(double mx, double my, double delta) {
        if (this.updateButton.m_5953_(mx, my)) {
            if (delta > 0.0 && this.contentGUI.updateSpeed < 5) {
                ++this.contentGUI.updateSpeed;
            } else if (delta > 0.0 && this.contentGUI.updateSpeed < 60) {
                this.contentGUI.updateSpeed += 5;
            } else if (delta < 0.0 && this.contentGUI.updateSpeed > 5) {
                this.contentGUI.updateSpeed -= 5;
            } else if (delta < 0.0 && this.contentGUI.updateSpeed <= 5 && this.contentGUI.updateSpeed > 1) {
                --this.contentGUI.updateSpeed;
            }
            this.updateButton.m_93666_((Component)CommandUtils.CreateTextComponent(String.valueOf(this.contentGUI.updateSpeed)));
            this.contentGUI.setUpdateSpeed();
            return true;
        }
        if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY)) {
            for (CUDropDown dropDown : this.topDropDowns) {
                if (!dropDown.scroll(mx, my, delta)) continue;
                return true;
            }
            this.contentGUI.scroll(mx, my, delta, this.centerX, this.centerY);
            return true;
        }
        return super.m_6050_(mx, my, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.contentGUI.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.contentGUI.charTyped(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    public void updateSelection(DropDownType ddtype, String s) {
        this.contentGUI.updateSelection(ddtype, s);
    }

    public static CUScreen openCUScreen(ResourceKey<Level> world, BlockPos pos) {
        if (stored == null || !keep || !world.equals(CUScreen.stored.dim)) {
            keep = false;
            stored = new CUScreen(world, pos);
            return stored;
        }
        CUContentPane cUContentPane = CUScreen.stored.contentGUI;
        if (cUContentPane instanceof DataListGUI) {
            DataListGUI gui = (DataListGUI)cUContentPane;
            if (!gui.loader.history.isEmpty()) {
                gui.loader.history.get(gui.loader.history.size() - 1).accept(false);
                gui.loader.history.remove(gui.loader.history.size() - 1);
            }
        }
        DataHolder.notifyListener();
        CUScreen.stored.contentGUI.setUpdateSpeed();
        return stored;
    }

    static {
        WINDOW = new ResourceLocation("crashutilities", "textures/gui/cuscreen.png");
        TABS = new ResourceLocation("crashutilities", "textures/gui/tabs.png");
        keep = false;
    }
}

