/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.google.common.base.MoreObjects;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public interface ItemSearchMode {
    public static final ItemSearchMode ALL_ITEMS = new ItemSearchMode(){
        private List<ItemStack> allItemsCache = null;

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.f_42522_);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_item.list_mode.all");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            if (this.allItemsCache == null) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(Registry.f_122827_.m_6566_().size() + 100);
                for (Item item : Registry.f_122827_) {
                    NonNullList list = NonNullList.m_122779_();
                    CreativeModeTab category = item.m_41471_();
                    item.m_6787_((CreativeModeTab)MoreObjects.firstNonNull((Object)category, (Object)CreativeModeTab.f_40754_), list);
                    if (list.isEmpty()) {
                        stacks.add(item.m_7968_());
                        continue;
                    }
                    stacks.addAll((Collection<ItemStack>)list);
                }
                this.allItemsCache = stacks;
            }
            return this.allItemsCache;
        }
    };
    public static final ItemSearchMode INVENTORY = new ItemSearchMode(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.f_42009_);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_item.list_mode.inv");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return Collections.emptySet();
            }
            int inv = player.m_150109_().m_6643_();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(inv);
            for (int i = 0; i < inv; ++i) {
                ItemStack stack = Minecraft.m_91087_().f_91074_.m_150109_().m_8020_(i);
                if (stack.m_41619_()) continue;
                items.add(stack);
            }
            return items;
        }
    };

    public Icon getIcon();

    public MutableComponent getDisplayName();

    public Collection<ItemStack> getAllItems();
}

