/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.net.EditNBTPacket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FTBLibraryCommands {
    public static final Map<UUID, CompoundTag> EDITING_NBT = new HashMap<UUID, CompoundTag>();

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection type) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftblibrary").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"gamemode").executes(context -> {
            if (!((CommandSourceStack)context.getSource()).m_81375_().m_7500_()) {
                ((CommandSourceStack)context.getSource()).m_81375_().m_143403_(GameType.CREATIVE);
            } else {
                ((CommandSourceStack)context.getSource()).m_81375_().m_143403_(GameType.SURVIVAL);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"rain").executes(context -> {
            if (((CommandSourceStack)context.getSource()).m_81372_().m_46471_()) {
                ((CommandSourceStack)context.getSource()).m_81372_().m_8606_(6000, 0, false, false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81372_().m_8606_(0, 6000, true, false);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"day").executes(context -> {
            long addDay = (24000L - ((CommandSourceStack)context.getSource()).m_81372_().m_46468_() % 24000L + 6000L) % 24000L;
            if (addDay != 0L) {
                for (ServerLevel world : ((CommandSourceStack)context.getSource()).m_81377_().m_129785_()) {
                    world.m_8615_(world.m_46468_() + addDay);
                }
            }
            return 1;
        }))).then(Commands.m_82127_((String)"night").executes(context -> {
            long addDay = (24000L - ((CommandSourceStack)context.getSource()).m_81372_().m_46468_() % 24000L + 18000L) % 24000L;
            if (addDay != 0L) {
                for (ServerLevel world : ((CommandSourceStack)context.getSource()).m_81377_().m_129785_()) {
                    world.m_8615_(world.m_46468_() + addDay);
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nbtedit").then(Commands.m_82127_((String)"block").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> {
            Component title;
            BlockPos pos = BlockPosArgument.m_174395_((CommandContext)context, (String)"pos");
            BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).m_81372_().m_7702_(pos);
            if (blockEntity == null) {
                return;
            }
            info.m_128359_("type", "block");
            info.m_128405_("x", pos.m_123341_());
            info.m_128405_("y", pos.m_123342_());
            info.m_128405_("z", pos.m_123343_());
            tag.m_128391_(blockEntity.m_187480_());
            tag.m_128473_("x");
            tag.m_128473_("y");
            tag.m_128473_("z");
            info.m_128359_("id", tag.m_128461_("id"));
            tag.m_128473_("id");
            ListTag list = new ListTag();
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"Class"), (Component)Component.m_237113_((String)blockEntity.getClass().getName()));
            ResourceLocation key = Registries.getId((Object)blockEntity.m_58903_(), (ResourceKey)Registry.f_122907_);
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"ID"), (Component)Component.m_237113_((String)(key == null ? "null" : key.toString())));
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"Block"), (Component)Component.m_237113_((String)String.valueOf(Registries.getId((Object)blockEntity.m_58900_().m_60734_(), (ResourceKey)Registry.f_122901_))));
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"Block Class"), (Component)Component.m_237113_((String)blockEntity.m_58900_().m_60734_().getClass().getName()));
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"Position"), (Component)Component.m_237113_((String)("[" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + "]")));
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"Mod"), (Component)Component.m_237113_((String)(key == null ? "null" : Platform.getOptionalMod((String)key.m_135827_()).map(Mod::getName).orElse("Unknown"))));
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"Ticking"), (Component)Component.m_237113_((String)(blockEntity instanceof TickingBlockEntity ? "true" : "false")));
            info.m_128365_("text", (Tag)list);
            Component component = title = blockEntity instanceof Nameable ? ((Nameable)blockEntity).m_5446_() : null;
            if (title == null) {
                title = Component.m_237113_((String)blockEntity.getClass().getSimpleName());
            }
            info.m_128359_("title", Component.Serializer.m_130703_((Component)title));
        }))))).then(Commands.m_82127_((String)"entity").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"entity");
            if (entity instanceof Player) {
                return;
            }
            info.m_128359_("type", "entity");
            info.m_128405_("id", entity.m_19879_());
            entity.m_20223_(tag);
            ListTag list = new ListTag();
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"Class"), (Component)Component.m_237113_((String)entity.getClass().getName()));
            ResourceLocation key = Registries.getId((Object)entity.m_6095_(), (ResourceKey)Registry.f_122903_);
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"ID"), (Component)Component.m_237113_((String)(key == null ? "null" : key.toString())));
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"Mod"), (Component)Component.m_237113_((String)(key == null ? "null" : Platform.getOptionalMod((String)key.m_135827_()).map(Mod::getName).orElse("Unknown"))));
            info.m_128365_("text", (Tag)list);
            info.m_128359_("title", Component.Serializer.m_130703_((Component)entity.m_5446_()));
        }))))).then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            info.m_128359_("type", "player");
            info.m_128362_("id", player.m_20148_());
            player.m_20240_(tag);
            tag.m_128473_("id");
            ListTag list = new ListTag();
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"Name"), player.m_7755_());
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"Display Name"), player.m_5446_());
            FTBLibraryCommands.addInfo(list, (Component)Component.m_237113_((String)"UUID"), (Component)Component.m_237113_((String)player.m_20148_().toString()));
            info.m_128365_("text", (Tag)list);
            info.m_128359_("title", Component.Serializer.m_130703_((Component)player.m_5446_()));
        }))))).then(Commands.m_82127_((String)"item").executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSourceStack>)context, (info, tag) -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            info.m_128359_("type", "item");
            player.m_21120_(InteractionHand.MAIN_HAND).m_41739_(tag);
        }))))).then(Commands.m_82127_((String)"generate_loot_tables").executes(FTBLibraryCommands::generateLootTables));
        if (Platform.isDevelopmentEnvironment()) {
            command.then(Commands.m_82127_((String)"test_screen").executes(context -> {
                FTBLibrary.PROXY.testScreen();
                return 1;
            }));
        }
        dispatcher.register(command);
    }

    private static int generateLootTables(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        HitResult pick = player.m_19907_(30.0, 1.0f, true);
        if (pick.m_6662_() != HitResult.Type.BLOCK) {
            source.m_81352_((Component)Component.m_237113_((String)"You must be facing a valid block"));
            return 0;
        }
        BlockHitResult trace = (BlockHitResult)pick;
        ServerLevel level = source.m_81372_();
        BlockEntity blockEntity = level.m_7702_(trace.m_82425_());
        if (!(blockEntity instanceof ChestBlockEntity) && !(blockEntity instanceof BarrelBlockEntity)) {
            source.m_81352_((Component)Component.m_237113_((String)"You must be facing a chest or barrel"));
            return 0;
        }
        RandomizableContainerBlockEntity chest = (RandomizableContainerBlockEntity)blockEntity;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < chest.m_6643_(); ++i) {
            ItemStack item = chest.m_8020_(i);
            if (item.m_41619_()) continue;
            items.add(item);
        }
        try {
            String chestPathName;
            LootPool.Builder tablePool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            for (ItemStack e : items) {
                BlockItem blockItem;
                Item item;
                CompoundTag itemTag;
                LootPoolSingletonContainer.Builder itemBuilder = LootItem.m_79579_((ItemLike)e.m_41720_()).m_79707_(1);
                if (e.m_41613_() > 1) {
                    itemBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)e.m_41613_())));
                }
                if ((itemTag = e.m_41784_()).m_128441_("copy") || e.m_41720_() instanceof EnchantedBookItem || (item = e.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock) {
                    itemBuilder.m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)itemTag));
                } else if (e.m_41793_()) {
                    if (itemTag.m_128441_("level")) {
                        String range = itemTag.m_128461_("level");
                        if (range.contains(",")) {
                            String[] split = range.split(",");
                            itemBuilder.m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)Float.parseFloat(split[0]), (float)Float.parseFloat(split[1]))));
                        } else {
                            itemBuilder.m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)Float.parseFloat(range))));
                        }
                    } else if (itemTag.m_128441_("set")) {
                        SetEnchantmentsFunction.Builder enchantBuilder = new SetEnchantmentsFunction.Builder();
                        EnchantmentHelper.m_44831_((ItemStack)e).forEach((enchant, l) -> enchantBuilder.m_165374_(enchant, (NumberProvider)ConstantValue.m_165692_((float)l.intValue())));
                        itemBuilder.m_79078_((LootItemFunction.Builder)enchantBuilder);
                    } else {
                        itemBuilder.m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_());
                    }
                }
                tablePool.m_79076_((LootPoolEntryContainer.Builder)itemBuilder);
            }
            LootTable.Builder lootTable = LootTable.m_79147_().m_79161_(tablePool);
            Gson gson = Deserializers.m_78800_().setPrettyPrinting().create();
            String output = gson.toJson((Object)lootTable.m_79167_());
            Path path = source.m_81377_().m_6237_().toPath();
            Path outputDir = path.resolve("moddata/ftb-library/generated/");
            Object outputFileName = "loot-" + (blockEntity instanceof ChestBlockEntity ? "chest" : "barrel") + "-" + LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replaceAll(":|\\.", "_") + ".json";
            Component customName = chest.m_7770_();
            if (customName != null && customName.getString().contains("/") && !customName.getString().contains("..") && (chestPathName = customName.getString()).chars().filter(c -> c == 47).count() == 2L) {
                String[] pathParts = chestPathName.split("/");
                outputFileName = String.format("%s.json", pathParts[2]);
                outputDir = path.resolve(String.format("kubejs/%s/loot_tables/%s/", pathParts[0], pathParts[1]));
            }
            if (!Files.exists(outputDir, new LinkOption[0])) {
                Files.createDirectories(outputDir, new FileAttribute[0]);
            }
            Files.writeString(outputDir.resolve((String)outputFileName), (CharSequence)output, new OpenOption[0]);
            source.m_81354_((Component)Component.m_237113_((String)("Loot table stored at " + outputDir.resolve((String)outputFileName).toString().replace(path.toAbsolutePath().toString(), ""))), true);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)"Something went wrong, check the logs"));
            FTBLibrary.LOGGER.error((Object)e);
            return 0;
        }
        return 1;
    }

    private static void addInfo(ListTag list, Component key, Component value) {
        list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)key.m_6881_().m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)value.m_6881_().m_130940_(ChatFormatting.GOLD)))));
    }

    private static int editNBT(CommandContext<CommandSourceStack> context, NBTEditCallback data) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        CompoundTag info = new CompoundTag();
        CompoundTag tag = new CompoundTag();
        data.accept(info, tag);
        if (!info.m_128456_()) {
            EDITING_NBT.put(player.m_20148_(), info);
            new EditNBTPacket(info, tag).sendTo(player);
            return 1;
        }
        return 0;
    }

    private static interface NBTEditCallback {
        public void accept(CompoundTag var1, CompoundTag var2) throws CommandSyntaxException;
    }
}

