/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.contraption.source;

import com.hollingsworth.ars_creo.contraption.ContraptionUtils;
import com.hollingsworth.ars_creo.contraption.source.SourceInfo;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.simibubi.create.content.contraptions.Contraption;

public class ContraptionSource
implements ISourceTile {
    Contraption contraption;

    public ContraptionSource(Contraption contraption) {
        this.contraption = contraption;
    }

    public int getTransferRate() {
        return 10000;
    }

    public boolean canAcceptSource() {
        return this.getSource() < this.getMaxSource();
    }

    public int getSource() {
        int amount = 0;
        for (SourceInfo sourceInfo : ContraptionUtils.getSourceBlocks(this.contraption)) {
            amount += sourceInfo.getAmount();
        }
        return amount;
    }

    public int getMaxSource() {
        return ContraptionUtils.getSourceBlocks(this.contraption).size() * 10000;
    }

    public void setMaxSource(int max) {
    }

    public int setSource(int source) {
        if (source > this.getSource()) {
            this.addSource(source - this.getSource());
        }
        if (source < this.getSource()) {
            this.removeSource(this.getSource() - source);
        }
        return this.getSource();
    }

    public int addSource(int source) {
        int remaining = source;
        for (SourceInfo sourceInfo : ContraptionUtils.getSourceBlocks(this.contraption)) {
            if (remaining <= 0) break;
            int room = 10000 - sourceInfo.getAmount();
            if (room <= 0) continue;
            int toAdd = Math.min(room, remaining);
            sourceInfo.addWithUpdate(this.contraption.entity.f_19853_, toAdd, this.contraption.entity);
            remaining -= toAdd;
        }
        return this.getSource();
    }

    public int removeSource(int source) {
        int remaining = source;
        for (SourceInfo sourceInfo : ContraptionUtils.getSourceBlocks(this.contraption)) {
            if (remaining <= 0) break;
            int amountInJar = sourceInfo.getAmount();
            if (amountInJar <= 0) continue;
            int toRemove = Math.min(amountInJar, remaining);
            sourceInfo.removeWithUpdate(this.contraption.entity.f_19853_, toRemove, this.contraption.entity);
            System.out.println(amountInJar + " " + toRemove + " " + (remaining -= toRemove));
        }
        return this.getSource();
    }
}

