/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.contraption;

import com.hollingsworth.ars_creo.contraption.source.SourceInfo;
import com.hollingsworth.arsnouveau.common.block.CreativeSourceJar;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ContraptionUtils {
    public static boolean removeSourceFromContraption(MovementContext context, int amount, BlockPos turretPos) {
        ServerLevel world = (ServerLevel)context.world;
        int amountLeft = amount;
        int amountOnContraption = 0;
        List<SourceInfo> sourceInfos = ContraptionUtils.getSourceBlocks(context.contraption);
        for (SourceInfo info : sourceInfos) {
            if (info.blockInfo.f_74676_.m_60734_() == BlockRegistry.CREATIVE_SOURCE_JAR) {
                System.out.println("creative");
                return true;
            }
            amountOnContraption += info.getAmount();
        }
        if (amountOnContraption < amount) {
            return false;
        }
        for (SourceInfo info : sourceInfos) {
            if (info.getAmount() >= amountLeft) {
                info.removeWithUpdate((Level)world, amountLeft, context.contraption.entity);
                System.out.println("removing with update");
                return true;
            }
            amountLeft -= info.getAmount();
            info.removeWithUpdate((Level)world, info.getAmount(), context.contraption.entity);
        }
        System.out.println("Continueing");
        return true;
    }

    public static List<SourceInfo> getSourceBlocks(Contraption contraption) {
        ArrayList<SourceInfo> sourceBlocks = new ArrayList<SourceInfo>();
        for (StructureTemplate.StructureBlockInfo blockInfo : contraption.getBlocks().values()) {
            if (blockInfo.f_74676_.m_60734_() instanceof SourceJar) {
                int totalSource = blockInfo.f_74677_.m_128451_(SourceJarTile.SOURCE_TAG);
                sourceBlocks.add(new SourceInfo(blockInfo, totalSource));
            }
            if (!(blockInfo.f_74676_.m_60734_() instanceof CreativeSourceJar)) continue;
            sourceBlocks.add(new SourceInfo(blockInfo, 10000));
        }
        return sourceBlocks;
    }

    public static int getFillState(int source) {
        int fillState = 0;
        if (source > 0 && source < 1000) {
            fillState = 1;
        } else if (source != 0) {
            fillState = source / 1000 + 1;
        }
        return fillState;
    }
}

