/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.minecraft;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.StringUtils;

public class ShapedRecipeJS
extends RecipeJS {
    public ItemStack result;
    public final List<String> pattern = new ArrayList<String>();
    public final Map<Character, Ingredient> key = new LinkedHashMap<Character, Ingredient>();

    @Override
    public void create(RecipeArguments args) {
        if (args.size() < 3) {
            if (args.size() < 2) {
                throw new RecipeExceptionJS("Requires 3 arguments - result, pattern and keys!");
            }
            this.result = this.parseItemOutput(args.get(0));
            List<?> vertical = ListJS.orSelf(args.get(1));
            if (vertical.isEmpty()) {
                throw new RecipeExceptionJS("Pattern is empty!");
            }
            int id = 0;
            for (Object o : vertical) {
                StringBuilder horizontalPattern = new StringBuilder();
                List<?> horizontal = ListJS.orSelf(o);
                for (Object item : horizontal) {
                    Ingredient ingredient = IngredientJS.of(item);
                    if (!ingredient.m_43947_()) {
                        char currentChar = (char)(65 + id++);
                        horizontalPattern.append(currentChar);
                        this.key.put(Character.valueOf(currentChar), ingredient);
                        continue;
                    }
                    horizontalPattern.append(" ");
                }
                this.pattern.add(horizontalPattern.toString());
            }
            int maxLength = this.pattern.stream().mapToInt(String::length).max().getAsInt();
            ListIterator<String> iterator = this.pattern.listIterator();
            while (iterator.hasNext()) {
                iterator.set(StringUtils.rightPad((String)iterator.next(), (int)maxLength));
            }
            return;
        }
        this.result = this.parseItemOutput(args.get(0));
        List<?> pattern1 = ListJS.orSelf(args.get(1));
        if (pattern1.isEmpty()) {
            throw new RecipeExceptionJS("Pattern is empty!");
        }
        ArrayList<String> airs = new ArrayList<String>(1);
        Map<?, ?> key1 = MapJS.of(args.get(2));
        if (key1 == null || key1.isEmpty()) {
            throw new RecipeExceptionJS("Key map is empty!");
        }
        for (Object kr : key1.keySet()) {
            String k = String.valueOf(kr);
            Object o = key1.get(kr);
            if (o == ItemStack.f_41583_ || o.equals("minecraft:air")) {
                airs.add(k);
                continue;
            }
            this.key.put(Character.valueOf(k.charAt(0)), this.parseItemInput(o, k));
        }
        for (Object p : pattern1) {
            String s = String.valueOf(p);
            for (String s1 : airs) {
                s = s.replace(s1, " ");
            }
            this.pattern.add(s);
        }
    }

    @Override
    public void deserialize() {
        this.result = this.parseItemOutput(this.json.get("result"));
        for (JsonElement e : this.json.get("pattern").getAsJsonArray()) {
            this.pattern.add(e.getAsString());
        }
        for (Map.Entry entry : this.json.get("key").getAsJsonObject().entrySet()) {
            this.key.put(Character.valueOf(((String)entry.getKey()).charAt(0)), this.parseItemInput(entry.getValue(), (String)entry.getKey()));
        }
    }

    @Override
    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("result", this.itemToJson(this.result));
        }
        if (this.serializeInputs) {
            JsonArray patternJson = new JsonArray();
            for (String s : this.pattern) {
                patternJson.add(s);
            }
            this.json.add("pattern", (JsonElement)patternJson);
            JsonObject keyJson = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                keyJson.add(entry.getKey().toString(), entry.getValue().m_43942_());
            }
            this.json.add("key", (JsonElement)keyJson);
        }
    }

    @Override
    public boolean hasInput(IngredientMatch match) {
        for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
            if (!match.contains(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceInput(IngredientMatch match, Ingredient with, ItemInputTransformer transformer) {
        boolean changed = false;
        for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
            if (!match.contains(entry.getValue())) continue;
            entry.setValue(transformer.transform(this, match, entry.getValue(), with));
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean hasOutput(IngredientMatch match) {
        return match.contains(this.result);
    }

    @Override
    public boolean replaceOutput(IngredientMatch match, ItemStack with, ItemOutputTransformer transformer) {
        if (match.contains(this.result)) {
            this.result = transformer.transform(this, match, this.result, with);
            return true;
        }
        return false;
    }

    public ShapedRecipeJS noMirror() {
        this.json.addProperty("mirror", Boolean.valueOf(false));
        this.save();
        return this;
    }

    public ShapedRecipeJS noShrink() {
        this.json.addProperty("shrink", Boolean.valueOf(false));
        this.save();
        return this;
    }
}

