/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public interface ItemStackJS {
    public static final Map<String, ItemStack> PARSE_CACHE = new HashMap<String, ItemStack>();
    public static final ItemStack[] EMPTY_ARRAY = new ItemStack[0];
    public static final Lazy<List<ItemStack>> CACHED_ITEM_LIST = Lazy.of(() -> {
        LinkedHashSet<ItemStack> set = new LinkedHashSet<ItemStack>();
        NonNullList stackList = NonNullList.m_122779_();
        for (Item item : KubeJSRegistries.items()) {
            try {
                item.m_6787_(CreativeModeTab.f_40754_, stackList);
            }
            catch (Throwable throwable) {}
        }
        for (ItemStack stack : stackList) {
            if (stack.m_41619_()) continue;
            set.add(stack.kjs$withCount(1));
        }
        return Arrays.asList(set.toArray(new ItemStack[0]));
    });
    public static final Lazy<List<String>> CACHED_ITEM_TYPE_LIST = Lazy.of(() -> {
        ArrayList<String> cachedItemTypeList = new ArrayList<String>();
        for (ResourceLocation id : KubeJSRegistries.items().getIds()) {
            cachedItemTypeList.add(id.toString());
        }
        return cachedItemTypeList;
    });

    public static ItemStack of(@Nullable Object o) {
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ItemStack.f_41583_ || o == Items.f_41852_) {
            return ItemStack.f_41583_;
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return stack.m_41619_() ? ItemStack.f_41583_ : stack;
        }
        if (o instanceof Ingredient) {
            Ingredient ingr = (Ingredient)o;
            return ingr.kjs$getFirst();
        }
        if (o instanceof ResourceLocation) {
            ResourceLocation id = (ResourceLocation)o;
            Item item = (Item)KubeJSRegistries.items().get(id);
            if (item == null || item == Items.f_41852_) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                }
                return ItemStack.f_41583_;
            }
            return item.m_7968_();
        }
        if (o instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)o;
            return new ItemStack((ItemLike)itemLike.m_5456_());
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return ItemStackJS.resultFromRecipeJson(json);
        }
        if (o instanceof StringTag) {
            StringTag tag = (StringTag)o;
            return ItemStackJS.of(tag.m_7916_());
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = UtilsJS.parseRegex(o);
            if (reg != null) {
                return IngredientPlatformHelper.get().regex(reg).kjs$getFirst();
            }
            return ItemStack.f_41583_;
        }
        if (o instanceof CharSequence) {
            String os;
            String s = os = o.toString().trim();
            ItemStack cached = PARSE_CACHE.get(os);
            if (cached != null) {
                return cached.m_41619_() ? ItemStack.f_41583_ : cached.m_41777_();
            }
            int count = 1;
            int spaceIndex = s.indexOf(32);
            if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                s = s.substring(spaceIndex + 1);
            }
            cached = ItemStackJS.parse(s);
            cached.m_41764_(count);
            PARSE_CACHE.put(os, cached);
            return cached.m_41777_();
        }
        Map<?, ?> map = MapJS.of(o);
        if (map != null) {
            if (map.containsKey("item")) {
                ResourceLocation id = UtilsJS.getMCID(null, map.get("item").toString());
                Item item = (Item)KubeJSRegistries.items().get(id);
                if (item == Items.f_41852_) {
                    if (RecipeJS.itemErrors) {
                        throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                    }
                    return ItemStack.f_41583_;
                }
                ItemStack stack = new ItemStack((ItemLike)item);
                Object obj = map.get("count");
                if (obj instanceof Number) {
                    Number number = (Number)obj;
                    stack.m_41764_(number.intValue());
                }
                if (map.containsKey("nbt")) {
                    stack.m_41751_(NBTUtils.toTagCompound(map.get("nbt")));
                }
                return stack;
            }
            Object id = map.get("tag");
            if (id instanceof CharSequence) {
                CharSequence s = (CharSequence)id;
                ItemStack stack = IngredientPlatformHelper.get().tag(s.toString()).kjs$getFirst();
                if (map.containsKey("count")) {
                    stack.m_41764_(UtilsJS.parseInt(map.get("count"), 1));
                }
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack parse(String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return ItemStack.f_41583_;
        }
        if (s.startsWith("#")) {
            return IngredientPlatformHelper.get().tag(s.substring(1)).kjs$getFirst();
        }
        if (s.startsWith("@")) {
            return IngredientPlatformHelper.get().mod(s.substring(1)).kjs$getFirst();
        }
        if (s.startsWith("%")) {
            CreativeModeTab group = UtilsJS.findCreativeTab(s.substring(1));
            if (group == null) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item group '" + s.substring(1) + "' not found!").error();
                }
                return ItemStack.f_41583_;
            }
            return IngredientPlatformHelper.get().creativeTab(group).kjs$getFirst();
        }
        Pattern reg = UtilsJS.parseRegex(s);
        if (reg != null) {
            return IngredientPlatformHelper.get().regex(reg).kjs$getFirst();
        }
        Item item = (Item)KubeJSRegistries.items().get(new ResourceLocation(s));
        if (item == Items.f_41852_) {
            if (RecipeJS.itemErrors) {
                throw new RecipeExceptionJS("Item '" + s + "' not found!").error();
            }
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)item);
    }

    public static Item getRawItem(Context cx, @Nullable Object o) {
        if (o == null) {
            return Items.f_41852_;
        }
        if (o instanceof Item) {
            Item item = (Item)o;
            return item;
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s.isEmpty()) {
                return Items.f_41852_;
            }
            if (s.charAt(0) != '#') {
                return (Item)KubeJSRegistries.items().get(UtilsJS.getMCID(cx, s));
            }
        }
        return ItemStackJS.of(o).m_41720_();
    }

    public static ItemStack resultFromRecipeJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ItemStack.f_41583_;
        }
        if (json.isJsonPrimitive()) {
            return ItemStackJS.of(json.getAsString());
        }
        if (json instanceof JsonObject) {
            ItemStack is;
            JsonObject jsonObj = (JsonObject)json;
            if (RecipeJS.currentRecipe != null && (is = RecipeJS.currentRecipe.resultFromRecipeJson(jsonObj)) != null) {
                return is;
            }
            ItemStack stack = null;
            if (jsonObj.has("item")) {
                stack = ItemStackJS.of(jsonObj.get("item").getAsString());
            } else if (jsonObj.has("tag")) {
                stack = IngredientPlatformHelper.get().tag(jsonObj.get("tag").getAsString()).kjs$getFirst();
            }
            if (stack != null) {
                if (jsonObj.has("count")) {
                    stack.m_41764_(jsonObj.get("count").getAsInt());
                } else if (jsonObj.has("amount")) {
                    stack.m_41764_(jsonObj.get("amount").getAsInt());
                }
                if (jsonObj.has("nbt")) {
                    JsonElement element = jsonObj.get("nbt");
                    if (element.isJsonObject()) {
                        stack.m_41751_(NBTUtils.toTagCompound((Object)element));
                    } else {
                        stack.m_41751_(NBTUtils.toTagCompound((Object)element.getAsString()));
                    }
                }
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static String toItemString(Object object) {
        return ItemStackJS.of(object).kjs$toItemString();
    }

    public static List<ItemStack> getList() {
        return CACHED_ITEM_LIST.get();
    }

    public static List<String> getTypeList() {
        return CACHED_ITEM_TYPE_LIST.get();
    }

    public static void clearAllCaches() {
        CACHED_ITEM_LIST.forget();
        CACHED_ITEM_TYPE_LIST.forget();
        PARSE_CACHE.clear();
        IngredientJS.PARSE_CACHE.clear();
    }
}

