/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.event;

import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandlerContainer;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.Extra;
import dev.latvian.mods.kubejs.event.IEventHandler;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public final class EventHandler
extends BaseFunction {
    public final EventGroup group;
    public final String name;
    public final ScriptType scriptType;
    public final Supplier<Class<? extends EventJS>> eventType;
    private boolean cancelable;
    public transient Extra extra;
    private EventHandlerContainer[] eventContainers;
    private Map<Object, EventHandlerContainer[]> extraEventContainers;

    EventHandler(EventGroup g, String n, ScriptType st, Supplier<Class<? extends EventJS>> e) {
        this.group = g;
        this.name = n;
        this.scriptType = st;
        this.eventType = e;
        this.cancelable = false;
        this.extra = null;
        this.eventContainers = null;
        this.extraEventContainers = null;
    }

    public EventHandler cancelable() {
        this.cancelable = true;
        return this;
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    @HideFromJS
    public EventHandler extra(Extra extra) {
        this.extra = extra;
        return this;
    }

    @HideFromJS
    public void clear(ScriptType type) {
        if (this.eventContainers != null) {
            this.eventContainers[type.ordinal()] = null;
            if (EventHandlerContainer.isEmpty(this.eventContainers)) {
                this.eventContainers = null;
            }
        }
        if (this.extraEventContainers != null) {
            Iterator<Map.Entry<Object, EventHandlerContainer[]>> entries = this.extraEventContainers.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<Object, EventHandlerContainer[]> entry = entries.next();
                entry.getValue()[type.ordinal()] = null;
                if (!EventHandlerContainer.isEmpty(entry.getValue())) continue;
                entries.remove();
            }
            if (this.extraEventContainers.isEmpty()) {
                this.extraEventContainers = null;
            }
        }
    }

    public void listen(ScriptType type, @Nullable Object extraId, IEventHandler handler) {
        EventHandlerContainer[] map;
        if (!type.manager.get().canListenEvents) {
            throw new IllegalStateException("Event handler '" + this + "' can only be registered during script loading!");
        }
        if (type != this.scriptType && !type.isStartup()) {
            EnumSet<ScriptType> types = EnumSet.of(this.scriptType, ScriptType.STARTUP);
            throw new UnsupportedOperationException("Tried to register event handler '" + this + "' for invalid script type " + type + "! Valid script types: " + types);
        }
        if (extraId != null && this.extra != null) {
            extraId = Wrapper.unwrapped((Object)extraId);
            extraId = this.extra.transformer.transform(extraId);
        }
        if (this.extra != null && this.extra.required && extraId == null) {
            throw new IllegalArgumentException("Event handler '" + this + "' requires extra id!");
        }
        if (this.extra == null && extraId != null) {
            throw new IllegalArgumentException("Event handler '" + this + "' doesn't support extra id!");
        }
        if (this.extra != null && extraId != null && !this.extra.validator.test(extraId)) {
            throw new IllegalArgumentException("Event handler '" + this + "' doesn't accept id '" + this.extra.toString.transform(extraId) + "'!");
        }
        if (extraId == null) {
            if (this.eventContainers == null) {
                this.eventContainers = new EventHandlerContainer[ScriptType.VALUES.length];
            }
            map = this.eventContainers;
        } else {
            if (this.extraEventContainers == null) {
                Map<Object, Object> map2 = this.extraEventContainers = this.extra.identity ? new IdentityHashMap() : new HashMap();
            }
            if ((map = this.extraEventContainers.get(extraId)) == null) {
                map = new EventHandlerContainer[ScriptType.VALUES.length];
                this.extraEventContainers.put(extraId, map);
            }
        }
        int index = type.ordinal();
        if (map[index] == null) {
            map[index] = new EventHandlerContainer(handler);
        } else {
            map[index].add(handler);
        }
    }

    public boolean post(EventJS event) {
        return this.post(null, event);
    }

    public boolean post(@Nullable Object extraId, EventJS event) {
        return this.post(extraId, event, false);
    }

    public boolean post(@Nullable Object extraId, EventJS event, boolean onlyPostToExtra) {
        EventHandlerContainer[] extraContainers;
        boolean b = false;
        if (extraId != null && this.extra != null) {
            extraId = Wrapper.unwrapped((Object)extraId);
            extraId = this.extra.transformer.transform(extraId);
        }
        if (this.extra != null && this.extra.required && extraId == null) {
            throw new IllegalArgumentException("Event handler '" + this + "' requires extra id!");
        }
        if (this.extra == null && extraId != null) {
            throw new IllegalArgumentException("Event handler '" + this + "' doesn't support extra id " + extraId + "!");
        }
        EventHandlerContainer[] eventHandlerContainerArray = extraContainers = this.extraEventContainers == null ? null : this.extraEventContainers.get(extraId);
        if (extraContainers != null && !(b = this.postToHandlers(this.scriptType, extraContainers, event)) && !this.scriptType.isStartup()) {
            b = this.postToHandlers(ScriptType.STARTUP, extraContainers, event);
        }
        if (!(b || this.eventContainers == null || onlyPostToExtra || (b = this.postToHandlers(this.scriptType, this.eventContainers, event)) || this.scriptType.isStartup())) {
            b = this.postToHandlers(ScriptType.STARTUP, this.eventContainers, event);
        }
        event.afterPosted(b);
        return b;
    }

    private boolean postToHandlers(ScriptType type, EventHandlerContainer[] containers, EventJS event) {
        EventHandlerContainer handler = containers[type.ordinal()];
        if (handler != null) {
            return handler.handle(type, this, event, this.isCancelable());
        }
        return false;
    }

    public String toString() {
        return this.group + "." + this.name;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ScriptType type = (ScriptType)((Object)cx.getProperty("Type", null));
        if (type == null) {
            throw new IllegalStateException("Unknown script type!");
        }
        try {
            if (args.length == 1) {
                this.listen(type, null, (IEventHandler)Context.jsToJava((Context)cx, (Object)args[0], IEventHandler.class));
            } else if (args.length == 2) {
                IEventHandler handler = (IEventHandler)Context.jsToJava((Context)cx, (Object)args[1], IEventHandler.class);
                for (Object o : ListJS.orSelf(args[0])) {
                    this.listen(type, o, handler);
                }
            }
        }
        catch (Exception ex) {
            type.console.error(ex.getLocalizedMessage());
        }
        return null;
    }
}

