/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.painter;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.latvian.mods.kubejs.bindings.event.ClientEvents;
import dev.latvian.mods.kubejs.client.ClientEventJS;
import dev.latvian.mods.kubejs.client.painter.PainterFactory;
import dev.latvian.mods.kubejs.client.painter.PainterObject;
import dev.latvian.mods.kubejs.client.painter.PainterObjectStorage;
import dev.latvian.mods.kubejs.client.painter.screen.AtlasTextureObject;
import dev.latvian.mods.kubejs.client.painter.screen.GradientObject;
import dev.latvian.mods.kubejs.client.painter.screen.ItemObject;
import dev.latvian.mods.kubejs.client.painter.screen.PaintScreenEventJS;
import dev.latvian.mods.kubejs.client.painter.screen.RectangleObject;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenGroup;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.mods.kubejs.client.painter.screen.TextObject;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.unit.FixedNumberUnit;
import dev.latvian.mods.unit.MutableNumberUnit;
import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.UnitContext;
import dev.latvian.mods.unit.UnitVariables;
import dev.latvian.mods.unit.VariableSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import org.jetbrains.annotations.Nullable;

public class Painter
implements UnitVariables {
    public static final Painter INSTANCE = new Painter();
    public static final int DRAW_ALWAYS = 0;
    public static final int DRAW_INGAME = 1;
    public static final int DRAW_GUI = 2;
    public static final int CENTER = 0;
    public static final int LEFT = -1;
    public static final int RIGHT = 1;
    public static final int TOP = -1;
    public static final int BOTTOM = 1;
    private final Object lock = new Object();
    private final Map<String, PainterFactory> objectRegistry = new HashMap<String, PainterFactory>();
    private final PainterObjectStorage storage = new PainterObjectStorage(this);
    private ScreenPainterObject[] screenObjects = null;
    public final UnitContext unitContext = UnitContext.DEFAULT.sub();
    private final VariableSet variables = new VariableSet();
    public final MutableNumberUnit deltaUnit = this.variables.setMutable("$Delta", 1.0);
    public final MutableNumberUnit screenWidthUnit;
    public final MutableNumberUnit screenHeightUnit;
    public final MutableNumberUnit mouseXUnit;
    public final MutableNumberUnit mouseYUnit;

    public Painter() {
        this.variables.set("$ScreenX", 0.0);
        this.variables.set("$ScreenY", 0.0);
        this.screenWidthUnit = this.variables.setMutable("$ScreenW", 1.0);
        this.screenHeightUnit = this.variables.setMutable("$ScreenH", 1.0);
        this.mouseXUnit = this.variables.setMutable("$MouseX", 0.0);
        this.mouseYUnit = this.variables.setMutable("MouseY", 0.0);
        this.variables.set("$delta", (Unit)this.deltaUnit);
        this.variables.set("$screenW", (Unit)this.screenWidthUnit);
        this.variables.set("$screenH", (Unit)this.screenHeightUnit);
        this.variables.set("$mouseX", (Unit)this.mouseXUnit);
        this.variables.set("$mouseY", (Unit)this.mouseYUnit);
    }

    public Unit unitOf(Context cx, Object o) {
        return this.unitOf(ConsoleJS.getCurrent(cx), o);
    }

    public Unit unitOf(ConsoleJS console, Object o) {
        if (o instanceof Unit) {
            Unit unit = (Unit)o;
            return unit;
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return FixedNumberUnit.of((double)number.floatValue());
        }
        try {
            if (o instanceof String) {
                return this.unitContext.parse(o.toString());
            }
            if (o instanceof StringTag) {
                StringTag tag = (StringTag)o;
                return this.unitContext.parse(tag.m_7916_());
            }
        }
        catch (Exception ex) {
            console.error("Failed to parse Unit: " + ex);
        }
        return FixedNumberUnit.ZERO;
    }

    @HideFromJS
    public void registerObject(String name, PainterFactory supplier) {
        this.objectRegistry.put(name, supplier);
    }

    public void registerBuiltinObjects() {
        this.registerObject("screen_group", ScreenGroup::new);
        this.registerObject("rectangle", RectangleObject::new);
        this.registerObject("text", TextObject::new);
        this.registerObject("atlas_texture", AtlasTextureObject::new);
        this.registerObject("gradient", GradientObject::new);
        this.registerObject("item", ItemObject::new);
    }

    @Nullable
    public PainterObject make(String type) {
        PainterFactory supplier = this.objectRegistry.get(type);
        return supplier == null ? null : supplier.create(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PainterObject getObject(String key) {
        Object object = this.lock;
        synchronized (object) {
            return this.storage.getObject(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(CompoundTag root) {
        Object object = this.lock;
        synchronized (object) {
            this.storage.handle(root);
            this.screenObjects = null;
            ClientEvents.PAINTER_UPDATED.post(new ClientEventJS());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.storage.clear();
            this.screenObjects = null;
            ClientEvents.PAINTER_UPDATED.post(new ClientEventJS());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HideFromJS
    public ScreenPainterObject[] getScreenObjects() {
        if (this.screenObjects == null) {
            Object object = this.lock;
            synchronized (object) {
                this.screenObjects = this.storage.createScreenObjects();
            }
        }
        return this.screenObjects;
    }

    public void setVariable(String key, Unit variable) {
        this.variables.set(key, variable);
    }

    public VariableSet getVariables() {
        return this.variables;
    }

    public void inGameScreenDraw(PoseStack matrices, float delta) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91066_.f_92063_ || mc.f_91080_ != null) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        PaintScreenEventJS event = new PaintScreenEventJS(mc, matrices, delta);
        this.deltaUnit.set((double)delta);
        this.screenWidthUnit.set((double)event.width);
        this.screenHeightUnit.set((double)event.height);
        this.mouseXUnit.set((double)event.width / 2.0);
        this.mouseYUnit.set((double)event.height / 2.0);
        ClientEvents.PAINT_SCREEN.post(event);
        for (ScreenPainterObject object : this.getScreenObjects()) {
            if (!object.visible.getBoolean((UnitVariables)event) || object.draw != 0 && object.draw != 1) continue;
            object.preDraw(event);
        }
        for (ScreenPainterObject object : this.getScreenObjects()) {
            if (!object.visible.getBoolean((UnitVariables)event) || object.draw != 0 && object.draw != 1) continue;
            object.draw(event);
        }
    }

    public void guiScreenDraw(Screen screen, PoseStack matrices, int mouseX, int mouseY, float delta) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        PaintScreenEventJS event = new PaintScreenEventJS(mc, screen, matrices, mouseX, mouseY, delta);
        this.deltaUnit.set((double)delta);
        this.screenWidthUnit.set((double)event.width);
        this.screenHeightUnit.set((double)event.height);
        this.mouseXUnit.set((double)mouseX);
        this.mouseYUnit.set((double)mouseY);
        event.resetShaderColor();
        ClientEvents.PAINT_SCREEN.post(event);
        for (ScreenPainterObject object : this.getScreenObjects()) {
            if (!object.visible.getBoolean((UnitVariables)event) || object.draw != 0 && object.draw != 2) continue;
            object.preDraw(event);
        }
        for (ScreenPainterObject object : this.getScreenObjects()) {
            if (!object.visible.getBoolean((UnitVariables)event) || object.draw != 0 && object.draw != 2) continue;
            object.draw(event);
        }
    }
}

